/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.Hc4Provider;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyFailedException;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyResult;
import org.sonatype.nexus.proxy.maven.routing.internal.AbstractRemoteStrategy;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;

public abstract class AbstractHttpRemoteStrategy
extends AbstractRemoteStrategy {
    private final HttpClientManager httpClientManager;

    protected AbstractHttpRemoteStrategy(int priority, String id, HttpClientManager httpClientManager) {
        super(priority, id);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    protected String getRemoteUrlOf(MavenProxyRepository mavenProxyRepository) throws MalformedURLException {
        String remoteRepositoryRootUrl = mavenProxyRepository.getRemoteUrl();
        URL remoteUrl = new URL(remoteRepositoryRootUrl);
        if (!"http".equalsIgnoreCase(remoteUrl.getProtocol()) && !"https".equalsIgnoreCase(remoteUrl.getProtocol())) {
            throw new MalformedURLException("URL protocol unsupported: " + remoteRepositoryRootUrl);
        }
        return remoteRepositoryRootUrl;
    }

    protected HttpClient createHttpClientFor(MavenProxyRepository mavenProxyRepository) {
        HttpClient client = this.httpClientManager.create(mavenProxyRepository, mavenProxyRepository.getRemoteStorageContext());
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIsBlacklistedRemoteServer(MavenProxyRepository mavenProxyRepository) throws StrategyFailedException, IOException {
        String remoteUrl;
        try {
            remoteUrl = this.getRemoteUrlOf(mavenProxyRepository);
        }
        catch (MalformedURLException e) {
            return;
        }
        HttpClient httpClient = this.createHttpClientFor(mavenProxyRepository);
        HttpGet get = new HttpGet(remoteUrl);
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute(Hc4Provider.HTTP_CTX_KEY_REPOSITORY, (Object)mavenProxyRepository);
        HttpResponse response = httpClient.execute((HttpUriRequest)get, (HttpContext)httpContext);
        try {
            String addressText;
            Document document;
            Elements addressElements;
            if (response.containsHeader("X-Artifactory-Id")) {
                this.log.debug("Remote server of proxy {} recognized as ARTF by response header", (Object)mavenProxyRepository);
                throw new StrategyFailedException("Server proxied by " + mavenProxyRepository + " proxy repository is not supported by automatic routing discovery");
            }
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 499 && response.getEntity() != null && !(addressElements = (document = Jsoup.parse((InputStream)response.getEntity().getContent(), null, (String)remoteUrl)).getElementsByTag("address")).isEmpty() && (addressText = addressElements.get(0).text()) != null && addressText.toLowerCase(Locale.ENGLISH).startsWith("artifactory")) {
                this.log.debug("Remote server of proxy {} recognized as ARTF by address element in body", (Object)mavenProxyRepository);
                throw new StrategyFailedException("Server proxied by " + mavenProxyRepository + " proxy repository is not supported by automatic routing discovery");
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    @Override
    public StrategyResult discover(MavenProxyRepository mavenProxyRepository) throws StrategyFailedException, IOException {
        this.checkIsBlacklistedRemoteServer(mavenProxyRepository);
        return this.doDiscover(mavenProxyRepository);
    }

    protected abstract StrategyResult doDiscover(MavenProxyRepository var1) throws StrategyFailedException, IOException;
}

