/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.discovery;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;

public class DiscoveryResult<R extends MavenRepository> {
    private final R mavenRepository;
    private final List<Outcome> outcomes;
    private PrefixSource prefixSource;

    public DiscoveryResult(R mavenRepository) {
        this.mavenRepository = (MavenRepository)Preconditions.checkNotNull(mavenRepository);
        this.outcomes = new ArrayList<Outcome>();
        this.prefixSource = null;
    }

    public R getMavenRepository() {
        return this.mavenRepository;
    }

    public boolean isSuccessful() {
        return this.getLastSuccessOutcome() != null;
    }

    public Outcome getLastResult() {
        return this.getLastOutcome();
    }

    public List<Outcome> getAllResults() {
        return Collections.unmodifiableList(this.outcomes);
    }

    public PrefixSource getPrefixSource() {
        return this.prefixSource;
    }

    public void recordSuccess(String usedStrategyId, String message, PrefixSource prefixSource) {
        if (!this.isSuccessful()) {
            Preconditions.checkNotNull((Object)usedStrategyId);
            Preconditions.checkNotNull((Object)message);
            Preconditions.checkNotNull((Object)prefixSource);
            OutcomeImpl success = new OutcomeImpl(usedStrategyId, true, message, null);
            this.outcomes.add(success);
            this.prefixSource = prefixSource;
        }
    }

    public void recordFailure(String usedStrategyId, String message) {
        if (!this.isSuccessful()) {
            Preconditions.checkNotNull((Object)usedStrategyId);
            Preconditions.checkNotNull((Object)message);
            OutcomeImpl failure = new OutcomeImpl(usedStrategyId, false, message, null);
            this.outcomes.add(failure);
        }
    }

    public void recordError(String usedStrategyId, Throwable errorCause) {
        if (!this.isSuccessful()) {
            Preconditions.checkNotNull((Object)usedStrategyId);
            Preconditions.checkNotNull((Object)errorCause);
            OutcomeImpl failure = new OutcomeImpl(usedStrategyId, false, errorCause.getMessage(), errorCause);
            this.outcomes.add(failure);
        }
    }

    protected Outcome getLastOutcome() {
        if (this.outcomes.size() > 0) {
            Outcome outcome = this.outcomes.get(this.outcomes.size() - 1);
            return outcome;
        }
        return null;
    }

    protected Outcome getLastSuccessOutcome() {
        Outcome outcome = this.getLastOutcome();
        if (outcome != null && outcome.isSuccessful()) {
            return outcome;
        }
        return null;
    }

    private static class OutcomeImpl
    implements Outcome {
        private final String strategyId;
        private final boolean successful;
        private final String message;
        private final Throwable throwable;

        private OutcomeImpl(String strategyId, boolean successful, String message, Throwable throwable) {
            this.strategyId = (String)Preconditions.checkNotNull((Object)strategyId);
            this.successful = successful;
            this.message = (String)Preconditions.checkNotNull((Object)message);
            this.throwable = throwable;
        }

        @Override
        public String getStrategyId() {
            return this.strategyId;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }

        public String toString() {
            return "Outcome[strategyId=" + this.strategyId + ", successful=" + this.successful + ", message=" + this.message + "]";
        }
    }

    public static interface Outcome {
        public String getStrategyId();

        public boolean isSuccessful();

        public String getMessage();

        public Throwable getThrowable();
    }
}

