/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing;

import com.google.common.base.Preconditions;

public class PublishingStatus {
    private final PStatus status;
    private final String lastPublishedMessage;
    private final long lastPublishedTimestamp;
    private final String lastPublishedFilePath;

    public PublishingStatus(PStatus status, String lastPublishedMessage, long lastPublishedTimestamp, String lastPublishedFilePath) {
        this.status = (PStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.lastPublishedMessage = (String)Preconditions.checkNotNull((Object)lastPublishedMessage);
        this.lastPublishedTimestamp = lastPublishedTimestamp;
        this.lastPublishedFilePath = lastPublishedFilePath;
    }

    public PStatus getStatus() {
        return this.status;
    }

    public String getLastPublishedMessage() {
        return this.lastPublishedMessage;
    }

    public long getLastPublishedTimestamp() {
        if (this.getStatus() == PStatus.PUBLISHED) {
            return this.lastPublishedTimestamp;
        }
        return -1L;
    }

    public String getLastPublishedFilePath() {
        if (this.getStatus() == PStatus.PUBLISHED) {
            return this.lastPublishedFilePath;
        }
        return null;
    }

    public static enum PStatus {
        PUBLISHED,
        NOT_PUBLISHED;

    }
}

