/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing;

import com.google.common.base.Preconditions;

public class DiscoveryStatus {
    private final DStatus status;
    private final String lastDiscoveryStrategy;
    private final String lastDiscoveryMessage;
    private final long lastDiscoveryTimestamp;

    public DiscoveryStatus(DStatus status) {
        Preconditions.checkArgument((status.ordinal() < DStatus.ENABLED_NOT_POSSIBLE.ordinal() ? 1 : 0) != 0);
        this.status = (DStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.lastDiscoveryStrategy = null;
        this.lastDiscoveryMessage = null;
        this.lastDiscoveryTimestamp = -1L;
    }

    public DiscoveryStatus(DStatus status, String lastDiscoveryStrategy, String lastDiscoveryMessage, long lastDiscoveryTimestamp) {
        Preconditions.checkArgument((status.ordinal() >= DStatus.ENABLED_NOT_POSSIBLE.ordinal() ? 1 : 0) != 0);
        Preconditions.checkArgument((lastDiscoveryTimestamp > 0L ? 1 : 0) != 0);
        this.status = (DStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.lastDiscoveryStrategy = (String)Preconditions.checkNotNull((Object)lastDiscoveryStrategy);
        this.lastDiscoveryMessage = (String)Preconditions.checkNotNull((Object)lastDiscoveryMessage);
        this.lastDiscoveryTimestamp = lastDiscoveryTimestamp;
    }

    public DStatus getStatus() {
        return this.status;
    }

    public String getLastDiscoveryStrategy() {
        return this.lastDiscoveryStrategy;
    }

    public String getLastDiscoveryMessage() {
        return this.lastDiscoveryMessage;
    }

    public long getLastDiscoveryTimestamp() {
        return this.lastDiscoveryTimestamp;
    }

    public static enum DStatus {
        NOT_A_PROXY,
        DISABLED,
        ENABLED_IN_PROGRESS,
        ENABLED_NOT_POSSIBLE,
        SUCCESSFUL,
        UNSUCCESSFUL,
        ERROR;


        public boolean isEnabled() {
            return this.ordinal() >= ENABLED_IN_PROGRESS.ordinal();
        }
    }
}

