/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.packaging;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.NexusConfiguration;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultArtifactPackagingMapper
extends ComponentSupport
implements ArtifactPackagingMapper {
    public static final String MAPPING_PROPERTIES_FILE = "packaging2extension-mapping.properties";
    private static final Map<String, String> defaults = Maps.newHashMapWithExpectedSize((int)15);
    private volatile File propertiesFile;
    private volatile Map<String, String> packaging2extensionMapping;

    @Inject
    public DefaultArtifactPackagingMapper(NexusConfiguration nexusConfiguration) {
        this.setPropertiesFile(new File(nexusConfiguration.getConfigurationDirectory(), MAPPING_PROPERTIES_FILE));
    }

    @Override
    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
        this.packaging2extensionMapping = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPackaging2extensionMapping() {
        if (this.packaging2extensionMapping == null) {
            DefaultArtifactPackagingMapper defaultArtifactPackagingMapper = this;
            synchronized (defaultArtifactPackagingMapper) {
                if (this.packaging2extensionMapping == null) {
                    this.packaging2extensionMapping = Maps.newHashMapWithExpectedSize((int)defaults.size());
                    this.packaging2extensionMapping.putAll(defaults);
                    if (this.propertiesFile != null && this.propertiesFile.exists()) {
                        this.log.info("Found artifact packaging mapping file {}", (Object)this.propertiesFile);
                        Properties userMappings = new Properties();
                        try (FileInputStream fis = new FileInputStream(this.propertiesFile);){
                            userMappings.load(fis);
                            if (userMappings.keySet().size() > 0) {
                                for (Object key : userMappings.keySet()) {
                                    this.packaging2extensionMapping.put(key.toString(), userMappings.getProperty(key.toString()));
                                }
                                this.log.info("User artifact packaging mapping file contained {} mappings", (Object)userMappings.keySet().size());
                            }
                        }
                        catch (IOException e) {
                            this.log.warn("Got IO exception during read of file: {}", (Object)this.propertiesFile.getAbsolutePath(), (Object)e);
                        }
                    } else {
                        this.log.debug("User artifact packaging mappings file not found, will work with defaults...");
                    }
                }
            }
        }
        return this.packaging2extensionMapping;
    }

    public Map<String, String> getDefaults() {
        return defaults;
    }

    @Override
    public String getExtensionForPackaging(String packaging) {
        if (packaging == null) {
            return "jar";
        }
        if (this.getPackaging2extensionMapping().containsKey(packaging)) {
            return this.getPackaging2extensionMapping().get(packaging);
        }
        return packaging;
    }

    static {
        defaults.put("ejb-client", "jar");
        defaults.put("ejb", "jar");
        defaults.put("rar", "jar");
        defaults.put("par", "jar");
        defaults.put("maven-plugin", "jar");
        defaults.put("maven-archetype", "jar");
        defaults.put("plexus-application", "jar");
        defaults.put("eclipse-plugin", "jar");
        defaults.put("eclipse-feature", "jar");
        defaults.put("eclipse-application", "zip");
        defaults.put("nexus-plugin", "jar");
        defaults.put("java-source", "jar");
        defaults.put("javadoc", "jar");
        defaults.put("test-jar", "jar");
        defaults.put("bundle", "jar");
    }
}

