/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final TimeZone TS_TZ = TimeZone.getTimeZone("UTC");
    public static final DateFormat TS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String getUTCTimestamp() {
        return TimeUtil.getUTCTimestamp(new Date());
    }

    public static String getUTCTimestamp(Date date) {
        return TS_FORMAT.format(date);
    }

    public static long toMillis(String ts) throws ParseException {
        Date dts = TimeUtil.toDate(ts);
        return dts.getTime();
    }

    static Date toDate(String ts) throws ParseException {
        Date dts = TS_FORMAT.parse(ts);
        return dts;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 0) {
            return;
        }
        if ("-t".equals(args[0])) {
            System.out.println(args[1] + " => " + new Date(TimeUtil.toMillis(args[1])));
            return;
        }
    }

    static {
        TS_FORMAT.setTimeZone(TS_TZ);
    }
}

