/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.sonatype.nexus.proxy.maven.metadata.operations.AbstractOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataUtil;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.SnapshotOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.VersionComparator;

public class SetSnapshotOperation
implements MetadataOperation {
    private SnapshotOperand operand;
    private final VersionComparator versionComparator = new VersionComparator();

    public SetSnapshotOperation(SnapshotOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(AbstractOperand data) throws MetadataException {
        if (data == null || !(data instanceof SnapshotOperand)) {
            throw new MetadataException("Operand is not correct: expected SnapshotOperand, but got " + (data == null ? "null" : data.getClass().getName()));
        }
        this.operand = (SnapshotOperand)data;
    }

    @Override
    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        return this.updateSnapshot(metadata);
    }

    private boolean updateSnapshot(Metadata metadata) throws MetadataException {
        Versioning vs = metadata.getVersioning();
        if (this.operand.getSnapshot() != null) {
            vs.setSnapshot(this.operand.getSnapshot());
        }
        List<SnapshotVersion> extras = this.operand.getSnapshotVersions();
        List currents = vs.getSnapshotVersions();
        if (extras != null && extras.size() > 0) {
            ModelVersionUtility.setModelVersion(metadata, ModelVersionUtility.LATEST_MODEL_VERSION);
            for (SnapshotVersion extra : extras) {
                SnapshotVersion current = MetadataUtil.searchForEquivalent(extra, currents);
                if (current == null) {
                    currents.add(extra);
                    continue;
                }
                if (this.versionComparator.compare(current.getVersion(), extra.getVersion()) >= 0) continue;
                currents.remove(current);
                currents.add(extra);
            }
        } else if (ModelVersionUtility.Version.V100 == this.operand.getOriginModelVersion() && this.operand.getSnapshot() != null) {
            for (SnapshotVersion current : currents) {
                current.setUpdated(this.operand.getTimestamp());
            }
        }
        vs.setLastUpdated(this.operand.getTimestamp());
        return true;
    }
}

