/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.util.ArrayList;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.maven.metadata.operations.AbstractOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddPluginOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddVersionOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.PluginOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.SetSnapshotOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.SnapshotOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.StringOperand;

public class NexusMergeOperation
implements MetadataOperation {
    private Metadata sourceMetadata;
    private ModelVersionUtility.Version sourceModelVersion;

    public NexusMergeOperation(MetadataOperand data) throws MetadataException {
        this.setOperand(data);
    }

    @Override
    public boolean perform(Metadata targetMetadata) throws MetadataException {
        if (this.sourceMetadata == null || targetMetadata == null) {
            return false;
        }
        String lastUpdated = null;
        if (!this.hasLastUpdatedSet(this.sourceMetadata) && !this.hasLastUpdatedSet(targetMetadata)) {
            lastUpdated = Long.toString(System.currentTimeMillis());
        } else if (!this.hasLastUpdatedSet(this.sourceMetadata) && this.hasLastUpdatedSet(targetMetadata)) {
            lastUpdated = targetMetadata.getVersioning().getLastUpdated();
        } else if (!this.hasLastUpdatedSet(targetMetadata) && this.hasLastUpdatedSet(this.sourceMetadata)) {
            lastUpdated = this.sourceMetadata.getVersioning().getLastUpdated();
        } else if (this.hasLastUpdatedSet(targetMetadata) && this.hasLastUpdatedSet(this.sourceMetadata)) {
            long sourceLU = -1L;
            long targetLU = -1L;
            try {
                sourceLU = Long.parseLong(this.sourceMetadata.getVersioning().getLastUpdated());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                targetLU = Long.parseLong(targetMetadata.getVersioning().getLastUpdated());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            lastUpdated = sourceLU >= targetLU ? Long.toString(sourceLU) : Long.toString(targetLU);
        }
        ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>();
        for (Plugin plugin : this.sourceMetadata.getPlugins()) {
            ops.add(new AddPluginOperation(new PluginOperand(this.sourceModelVersion, plugin)));
        }
        if (targetMetadata.getGroupId() == null) {
            targetMetadata.setGroupId(this.sourceMetadata.getGroupId());
        }
        if (targetMetadata.getArtifactId() == null) {
            targetMetadata.setArtifactId(this.sourceMetadata.getArtifactId());
        }
        if (targetMetadata.getVersion() == null) {
            targetMetadata.setVersion(this.sourceMetadata.getVersion());
        }
        if (this.sourceMetadata.getGroupId() != null && targetMetadata.getGroupId() != null && !this.sourceMetadata.getGroupId().equals(targetMetadata.getGroupId())) {
            throw new MetadataException("Could not merge metadata with different groupId: '" + this.sourceMetadata.getGroupId() + "' and '" + targetMetadata.getGroupId() + "'");
        }
        if (this.sourceMetadata.getArtifactId() != null && targetMetadata.getArtifactId() != null && !this.sourceMetadata.getArtifactId().equals(targetMetadata.getArtifactId())) {
            throw new MetadataException("Could not merge metadata with different artifactId: '" + this.sourceMetadata.getArtifactId() + "' and '" + targetMetadata.getArtifactId() + "'");
        }
        if (this.sourceMetadata.getVersioning() != null) {
            for (String version : this.sourceMetadata.getVersioning().getVersions()) {
                ops.add(new AddVersionOperation(new StringOperand(this.sourceModelVersion, version)));
            }
            Snapshot sourceSnapshot = this.sourceMetadata.getVersioning().getSnapshot();
            if (sourceSnapshot != null) {
                long timestamp = -1L;
                if (targetMetadata.getVersioning() != null && targetMetadata.getVersioning().getSnapshot() != null && targetMetadata.getVersioning().getSnapshot().getTimestamp() != null) {
                    try {
                        timestamp = Long.parseLong(targetMetadata.getVersioning().getSnapshot().getTimestamp().replace(".", ""));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                long sourceTimestamp = -1L;
                if (sourceSnapshot.getTimestamp() != null) {
                    try {
                        sourceTimestamp = Long.parseLong(sourceSnapshot.getTimestamp().replace(".", ""));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (sourceTimestamp != -1L && (timestamp == -1L || timestamp < sourceTimestamp)) {
                    ops.add(new SetSnapshotOperation(new SnapshotOperand(this.sourceModelVersion, this.sourceMetadata.getVersioning().getLastUpdated(), sourceSnapshot, this.sourceMetadata.getVersioning().getSnapshotVersions())));
                } else {
                    ops.add(new SetSnapshotOperation(new SnapshotOperand(this.sourceModelVersion, this.sourceMetadata.getVersioning().getLastUpdated(), null, this.sourceMetadata.getVersioning().getSnapshotVersions())));
                }
            }
        }
        MetadataBuilder.changeMetadata(targetMetadata, ops);
        if (targetMetadata.getVersioning() != null && lastUpdated != null) {
            targetMetadata.getVersioning().setLastUpdated(lastUpdated);
        }
        return true;
    }

    public void setOperand(AbstractOperand data) throws MetadataException {
        if (data == null || !(data instanceof MetadataOperand)) {
            throw new MetadataException("Operand is not correct: expected MetadataOperand, but got " + (data == null ? "null" : data.getClass().getName()));
        }
        this.sourceMetadata = ((MetadataOperand)data).getOperand();
        this.sourceModelVersion = ((MetadataOperand)data).getOriginModelVersion();
    }

    protected boolean hasLastUpdatedSet(Metadata md) {
        return md.getVersioning() != null && StringUtils.isNotBlank((String)md.getVersioning().getLastUpdated());
    }
}

