/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;

public class ModelVersionUtility {
    public static final Version LATEST_MODEL_VERSION = Version.values()[Version.values().length - 1];

    public static Version getModelVersion(Metadata metadata) {
        if ("1.1.0".equals(metadata.getModelVersion())) {
            return Version.V110;
        }
        return Version.V100;
    }

    public static void setModelVersion(Metadata metadata, Version version) {
        switch (version) {
            case V100: {
                metadata.setModelVersion(null);
                Versioning versioning = metadata.getVersioning();
                if (versioning == null) break;
                versioning.setSnapshotVersions(null);
                break;
            }
            case V110: {
                metadata.setModelVersion("1.1.0");
            }
        }
    }

    public static enum Version {
        V100,
        V110;

    }
}

