/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.TimeUtil;

public class MetadataBuilder {
    public static Metadata read(InputStream in) throws IOException {
        try {
            return new MetadataXpp3Reader().read(in);
        }
        catch (NullPointerException e) {
            throw new IOException("Malformed XML!", e);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    public static Metadata write(Metadata metadata, OutputStream out) throws IOException {
        if (metadata == null) {
            return metadata;
        }
        new MetadataXpp3Writer().write((Writer)WriterFactory.newXmlWriter((OutputStream)out), metadata);
        return metadata;
    }

    public static void changeMetadata(Metadata metadata, List<MetadataOperation> operations) throws MetadataException {
        if (metadata != null && operations != null && operations.size() > 0) {
            Metadata clone = metadata.clone();
            for (MetadataOperation op : operations) {
                op.perform(clone);
            }
            MetadataBuilder.replace(metadata, clone);
        }
    }

    public static Collection<MetadataException> changeMetadataIgnoringFailures(Metadata metadata, List<MetadataOperation> operations) {
        ArrayList<MetadataException> failures = new ArrayList<MetadataException>();
        if (metadata != null && operations != null && operations.size() > 0) {
            Metadata savePoint = metadata;
            for (MetadataOperation op : operations) {
                try {
                    Metadata clone = savePoint.clone();
                    op.perform(clone);
                    savePoint = clone;
                }
                catch (MetadataException e) {
                    failures.add(e);
                }
            }
            MetadataBuilder.replace(metadata, savePoint);
        }
        return failures;
    }

    private static void replace(Metadata metadata, Metadata newMetadata) {
        if (metadata == null || newMetadata == null) {
            return;
        }
        metadata.setArtifactId(newMetadata.getArtifactId());
        metadata.setGroupId(newMetadata.getGroupId());
        metadata.setModelEncoding(newMetadata.getModelEncoding());
        metadata.setModelVersion(newMetadata.getModelVersion());
        metadata.setPlugins(newMetadata.getPlugins());
        metadata.setVersion(newMetadata.getVersion());
        metadata.setVersioning(newMetadata.getVersioning());
    }

    public static void changeMetadata(Metadata metadata, MetadataOperation op) throws MetadataException {
        MetadataBuilder.changeMetadata(metadata, Collections.singletonList(op));
    }

    public static void changeMetadata(Metadata metadata, MetadataOperation ... ops) throws MetadataException {
        MetadataBuilder.changeMetadata(metadata, Arrays.asList(ops));
    }

    public static void updateTimestamp(Snapshot target) {
        target.setTimestamp(TimeUtil.getUTCTimestamp());
    }

    public static void updateTimestamp(Versioning target) {
        target.setLastUpdated(TimeUtil.getUTCTimestamp());
    }

    public static Snapshot createSnapshot(String version) {
        Snapshot sn = new Snapshot();
        if (version == null || version.length() < 3) {
            return sn;
        }
        String utc = TimeUtil.getUTCTimestamp();
        sn.setTimestamp(utc);
        if (version.endsWith("-SNAPSHOT")) {
            return sn;
        }
        int pos = version.lastIndexOf(45);
        if (pos == -1) {
            throw new IllegalArgumentException();
        }
        String sbn = version.substring(pos + 1);
        int bn = Integer.parseInt(sbn);
        sn.setBuildNumber(bn);
        String sts = version.substring(0, pos);
        pos = sts.lastIndexOf(45);
        if (pos == -1) {
            throw new IllegalArgumentException();
        }
        sn.setTimestamp(sts.substring(pos + 1));
        return sn;
    }
}

