/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.sonatype.nexus.proxy.maven.metadata.operations.AbstractOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;

public class MergeOperation
implements MetadataOperation {
    private Metadata sourceMetadata;

    public MergeOperation(MetadataOperand data) throws MetadataException {
        this.setOperand(data);
    }

    @Override
    public boolean perform(Metadata targetMetadata) throws MetadataException {
        boolean changed = false;
        if (this.sourceMetadata == null || targetMetadata == null) {
            return false;
        }
        List plugins = this.sourceMetadata.getPlugins();
        for (Plugin plugin : plugins) {
            boolean found = false;
            List targetPlugins = targetMetadata.getPlugins();
            Iterator iterator = targetPlugins.iterator();
            while (iterator.hasNext()) {
                Plugin preExisting = (Plugin)iterator.next();
                if (!preExisting.getPrefix().equals(plugin.getPrefix())) continue;
                found = true;
            }
            if (found) continue;
            Plugin mappedPlugin = new Plugin();
            mappedPlugin.setArtifactId(plugin.getArtifactId());
            mappedPlugin.setPrefix(plugin.getPrefix());
            mappedPlugin.setName(plugin.getName());
            targetMetadata.addPlugin(mappedPlugin);
            changed = true;
        }
        Versioning sourceVersioning = this.sourceMetadata.getVersioning();
        if (sourceVersioning != null) {
            Versioning targetVersioning = targetMetadata.getVersioning();
            if (targetVersioning == null) {
                targetVersioning = new Versioning();
                targetMetadata.setVersioning(targetVersioning);
                changed = true;
            }
            List versions = sourceVersioning.getVersions();
            for (String version : versions) {
                if (targetVersioning.getVersions().contains(version)) continue;
                changed = true;
                targetVersioning.getVersions().add(version);
            }
            if ("null".equals(sourceVersioning.getLastUpdated())) {
                sourceVersioning.setLastUpdated(null);
            }
            if ("null".equals(targetVersioning.getLastUpdated())) {
                targetVersioning.setLastUpdated(null);
            }
            if (sourceVersioning.getLastUpdated() == null || sourceVersioning.getLastUpdated().length() == 0) {
                sourceVersioning.setLastUpdated(targetVersioning.getLastUpdated());
            }
            if (targetVersioning.getLastUpdated() == null || targetVersioning.getLastUpdated().length() == 0 || sourceVersioning.getLastUpdated().compareTo(targetVersioning.getLastUpdated()) >= 0) {
                changed = true;
                targetVersioning.setLastUpdated(sourceVersioning.getLastUpdated());
                if (sourceVersioning.getRelease() != null) {
                    changed = true;
                    targetVersioning.setRelease(sourceVersioning.getRelease());
                }
                if (sourceVersioning.getLatest() != null) {
                    changed = true;
                    targetVersioning.setLatest(sourceVersioning.getLatest());
                }
                Snapshot s = targetVersioning.getSnapshot();
                Snapshot snapshot = sourceVersioning.getSnapshot();
                if (snapshot != null) {
                    if (s == null) {
                        s = new Snapshot();
                        targetVersioning.setSnapshot(s);
                        changed = true;
                    }
                    if (s.getTimestamp() == null ? snapshot.getTimestamp() != null : !s.getTimestamp().equals(snapshot.getTimestamp())) {
                        s.setTimestamp(snapshot.getTimestamp());
                        changed = true;
                    }
                    if (s.getBuildNumber() != snapshot.getBuildNumber()) {
                        s.setBuildNumber(snapshot.getBuildNumber());
                        changed = true;
                    }
                    if (s.isLocalCopy() != snapshot.isLocalCopy()) {
                        s.setLocalCopy(snapshot.isLocalCopy());
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public void setOperand(AbstractOperand data) throws MetadataException {
        if (data == null || !(data instanceof MetadataOperand)) {
            throw new MetadataException("Operand is not correct: expected MetadataOperand, but got " + (data == null ? "null" : data.getClass().getName()));
        }
        this.sourceMetadata = ((MetadataOperand)data).getOperand();
    }
}

