/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.sonatype.nexus.proxy.maven.metadata.operations.AbstractOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.StringOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.TimeUtil;
import org.sonatype.nexus.proxy.maven.metadata.operations.VersionComparator;

public class AddVersionOperation
implements MetadataOperation {
    private String version;

    public AddVersionOperation(StringOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(AbstractOperand data) throws MetadataException {
        if (data == null || !(data instanceof StringOperand)) {
            throw new MetadataException("Operand is not correct: expected StringOperand, but got " + (data == null ? "null" : data.getClass().getName()));
        }
        this.version = ((StringOperand)data).getOperand();
    }

    @Override
    public boolean perform(Metadata metadata) throws MetadataException {
        int index;
        List vl;
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        if (vs.getVersions() != null && vs.getVersions().size() > 0 && (vl = vs.getVersions()).contains(this.version)) {
            return false;
        }
        List versions = vs.getVersions();
        if (!(versions instanceof ArrayList2)) {
            Collections.sort(versions, new VersionComparator());
            vs.setVersions((List)new ArrayList2(versions));
            versions = vs.getVersions();
        }
        if ((index = Collections.binarySearch(versions, this.version, new VersionComparator())) < 0) {
            versions.add(-index - 1, this.version);
            vs.setLatest(this.getLatestVersion(versions));
            vs.setRelease(this.getReleaseVersion(versions));
            vs.setLastUpdated(TimeUtil.getUTCTimestamp());
            return true;
        }
        return false;
    }

    private String getLatestVersion(List<String> orderedVersions) {
        return orderedVersions.get(orderedVersions.size() - 1);
    }

    private String getReleaseVersion(List<String> orderedVersions) {
        for (int i = orderedVersions.size() - 1; i >= 0; --i) {
            if (orderedVersions.get(i).endsWith("SNAPSHOT")) continue;
            return orderedVersions.get(i);
        }
        return "";
    }

    public static class ArrayList2
    extends ArrayList<String> {
        public ArrayList2(Collection<? extends String> c) {
            super(c);
        }
    }
}

