/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata.operations;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.sonatype.nexus.proxy.maven.metadata.operations.AbstractOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataUtil;
import org.sonatype.nexus.proxy.maven.metadata.operations.PluginOperand;

public class AddPluginOperation
implements MetadataOperation {
    private Plugin plugin;
    private static PluginComparator pluginComparator;

    public AddPluginOperation(PluginOperand data) throws MetadataException {
        pluginComparator = new PluginComparator();
        if (data == null) {
            throw new MetadataException("Operand is not correct: cannot accept null!");
        }
        this.plugin = data.getOperand();
    }

    public void setOperand(AbstractOperand data) throws MetadataException {
        if (data == null || !(data instanceof PluginOperand)) {
            throw new MetadataException("Operand is not correct: expected PluginOperand, but got " + (data == null ? "null" : data.getClass().getName()));
        }
        this.plugin = ((PluginOperand)data).getOperand();
    }

    @Override
    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        List plugins = metadata.getPlugins();
        for (Plugin p : plugins) {
            if (!p.getArtifactId().equals(this.plugin.getArtifactId()) || !MetadataUtil.isPluginPrefixAndArtifactIdEquals(p, this.plugin)) continue;
            p.setName(this.plugin.getName());
            return false;
        }
        plugins.add(this.plugin);
        Collections.sort(plugins, pluginComparator);
        return true;
    }

    class PluginComparator
    implements Comparator<Plugin> {
        PluginComparator() {
        }

        @Override
        public int compare(Plugin p1, Plugin p2) {
            if (p1 == null || p2 == null) {
                throw new IllegalArgumentException();
            }
            if (p1.getArtifactId() == null || p2.getArtifactId() == null) {
                throw new IllegalArgumentException();
            }
            return p1.getArtifactId().compareTo(p2.getArtifactId());
        }
    }
}

