/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.M2GavCalculator;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataUtil;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.SetSnapshotOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.SnapshotOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.TimeUtil;

public class VersionDirMetadataProcessor
extends AbstractMetadataProcessor {
    public VersionDirMetadataProcessor(AbstractMetadataHelper metadataHelper) {
        super(metadataHelper);
    }

    @Override
    public boolean shouldProcessMetadata(String path) {
        Collection<String> names = this.metadataHelper.gavData.get(path);
        return names != null && !names.isEmpty();
    }

    @Override
    public void processMetadata(String path, Metadata oldMd) throws IOException {
        Metadata md = this.createMetadata(path);
        this.maybeFixClassifierAndExtension(md, oldMd);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MetadataBuilder.write(md, outputStream);
        String mdString = outputStream.toString();
        outputStream.close();
        this.metadataHelper.store(mdString, path + "/maven-metadata.xml");
    }

    private void maybeFixClassifierAndExtension(Metadata mdNew, Metadata mdOld) {
        Map<String, SnapshotVersion> svOld;
        if (mdNew != null && mdOld != null && !(svOld = this.createSnapshotVersionMap(mdOld)).isEmpty()) {
            Map<String, SnapshotVersion> svNew = this.createSnapshotVersionMap(mdNew);
            for (Map.Entry<String, SnapshotVersion> entry : svNew.entrySet()) {
                SnapshotVersion vOld = svOld.get(entry.getKey());
                if (vOld == null) continue;
                SnapshotVersion vNew = entry.getValue();
                vNew.setClassifier(vOld.getClassifier());
                vNew.setExtension(vOld.getExtension());
            }
        }
    }

    private Map<String, SnapshotVersion> createSnapshotVersionMap(Metadata md) {
        HashMap sv = Maps.newHashMap();
        if (md.getVersioning() != null && md.getVersioning().getSnapshotVersions() != null) {
            for (SnapshotVersion v : md.getVersioning().getSnapshotVersions()) {
                if (v.getClassifier() == null) continue;
                sv.put(String.format("%s-%s.%s", v.getVersion(), v.getClassifier(), v.getExtension()), v);
            }
        }
        return sv;
    }

    private Metadata createMetadata(String path) throws IOException {
        try {
            Metadata md = new Metadata();
            md.setGroupId(this.calculateGroupId(path));
            md.setArtifactId(this.calculateArtifactId(path));
            md.setVersion(this.calculateVersion(path));
            ModelVersionUtility.setModelVersion(md, ModelVersionUtility.LATEST_MODEL_VERSION);
            this.versioning(md, this.getGavs(path, this.metadataHelper.gavData.get(path)));
            return md;
        }
        catch (MetadataException e) {
            throw new IOException(e);
        }
    }

    private Collection<Gav> getGavs(String path, Collection<String> items) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        M2GavCalculator calc = new M2GavCalculator();
        ArrayList<Gav> gavs = new ArrayList<Gav>();
        Collections.sort((ArrayList)items);
        for (String item : items) {
            Gav gav = calc.pathToGav(path + item);
            if (gav == null) continue;
            gavs.add(gav);
        }
        return gavs;
    }

    private String calculateGroupId(String path) {
        String gaPath = path.substring(0, path.lastIndexOf(47));
        return gaPath.substring(1, gaPath.lastIndexOf(47)).replace('/', '.');
    }

    private String calculateArtifactId(String path) {
        String gaPath = path.substring(0, path.lastIndexOf(47));
        return gaPath.substring(gaPath.lastIndexOf(47) + 1);
    }

    private String calculateVersion(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    void versioning(Metadata metadata, Collection<Gav> artifactNames) throws MetadataException {
        ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>();
        for (Gav gav : artifactNames) {
            ops.add(new SetSnapshotOperation(new SnapshotOperand(ModelVersionUtility.LATEST_MODEL_VERSION, TimeUtil.getUTCTimestamp(), this.buildSnapshot(gav), this.buildVersion(gav))));
        }
        MetadataBuilder.changeMetadata(metadata, ops);
    }

    private SnapshotVersion[] buildVersion(Gav gav) throws MetadataException {
        if (gav.getBaseVersion().equals(gav.getVersion())) {
            return new SnapshotVersion[0];
        }
        SnapshotVersion snap = new SnapshotVersion();
        snap.setClassifier(gav.getClassifier());
        snap.setExtension(gav.getExtension());
        snap.setVersion(gav.getVersion());
        Snapshot timestamp = this.buildSnapshot(gav);
        if (timestamp != null) {
            snap.setUpdated(timestamp.getTimestamp().replace(".", ""));
        } else {
            snap.setUpdated(TimeUtil.getUTCTimestamp().replace(".", ""));
        }
        return new SnapshotVersion[]{snap};
    }

    private Snapshot buildSnapshot(Gav gav) {
        Snapshot result = new Snapshot();
        String version = gav.getVersion();
        if (version.equals(gav.getBaseVersion())) {
            return null;
        }
        int lastHyphenPos = version.lastIndexOf(45);
        int buildNumber = Integer.parseInt(version.substring(lastHyphenPos + 1));
        String timestamp = version.substring(gav.getBaseVersion().length() - 8, lastHyphenPos);
        result.setLocalCopy(false);
        result.setBuildNumber(buildNumber);
        result.setTimestamp(timestamp);
        return result;
    }

    @Override
    public void postProcessMetadata(String path) {
        this.metadataHelper.gavData.remove(path);
    }

    @Override
    protected boolean isMetadataCorrect(Metadata oldMd, String path) throws IOException {
        if (oldMd.getArtifactId() == null || oldMd.getGroupId() == null || oldMd.getVersion() == null || oldMd.getVersioning() == null || oldMd.getVersioning().getSnapshot() == null || oldMd.getVersioning().getSnapshot().getTimestamp() == null) {
            return false;
        }
        Metadata md = this.createMetadata(path);
        return StringUtils.equals((String)oldMd.getArtifactId(), (String)md.getArtifactId()) && StringUtils.equals((String)oldMd.getGroupId(), (String)md.getGroupId()) && StringUtils.equals((String)oldMd.getVersion(), (String)md.getVersion()) && md.getVersioning() != null && md.getVersioning().getSnapshot() != null && StringUtils.equals((String)oldMd.getVersioning().getSnapshot().getTimestamp(), (String)md.getVersioning().getSnapshot().getTimestamp()) && oldMd.getVersioning().getSnapshot().getBuildNumber() == md.getVersioning().getSnapshot().getBuildNumber() && oldMd.getVersioning().getVersions().containsAll(md.getVersioning().getVersions()) && md.getVersioning().getVersions().containsAll(oldMd.getVersioning().getVersions()) && this.equals(oldMd.getVersioning().getSnapshotVersions(), md.getVersioning().getSnapshotVersions());
    }

    private boolean equals(List<SnapshotVersion> old, List<SnapshotVersion> md) {
        if (old.size() != md.size()) {
            return false;
        }
        for (SnapshotVersion version : md) {
            SnapshotVersion oldVersion = MetadataUtil.searchForEquivalent(version, old);
            if (oldVersion == null) {
                return false;
            }
            if (StringUtils.equals((String)oldVersion.getVersion(), (String)version.getVersion()) && StringUtils.equals((String)oldVersion.getUpdated(), (String)version.getUpdated())) continue;
            return false;
        }
        return true;
    }
}

