/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddPluginOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataUtil;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.PluginOperand;

public class GroupDirMetadataProcessor
extends AbstractMetadataProcessor {
    public GroupDirMetadataProcessor(AbstractMetadataHelper metadataHelper) {
        super(metadataHelper);
    }

    @Override
    public void processMetadata(String path) throws IOException {
        Metadata md = this.createMetadata(path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MetadataBuilder.write(md, outputStream);
        String mdString = outputStream.toString();
        outputStream.close();
        this.metadataHelper.store(mdString, path + "/maven-metadata.xml");
    }

    private Metadata createMetadata(String path) throws IOException {
        try {
            Metadata md = new Metadata();
            ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>();
            for (Plugin plugin : this.metadataHelper.gData.get(path)) {
                ops.add(new AddPluginOperation(new PluginOperand(ModelVersionUtility.LATEST_MODEL_VERSION, plugin)));
            }
            MetadataBuilder.changeMetadata(md, ops);
            return md;
        }
        catch (MetadataException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean shouldProcessMetadata(String path) {
        Collection<Plugin> plugins = this.metadataHelper.gData.get(path);
        return plugins != null && !plugins.isEmpty();
    }

    @Override
    public void postProcessMetadata(String path) {
        this.metadataHelper.gData.remove(path);
    }

    @Override
    protected boolean isMetadataCorrect(Metadata oldMd, String path) throws IOException {
        Metadata md = this.createMetadata(path);
        List oldPlugins = oldMd.getPlugins();
        if (oldPlugins == null) {
            return false;
        }
        List plugins = md.getPlugins();
        if (oldPlugins.size() != plugins.size()) {
            return false;
        }
        for (int i = 0; i < oldPlugins.size(); ++i) {
            Plugin oldPlugin = (Plugin)oldPlugins.get(i);
            if (this.containPlugin(plugins, oldPlugin)) continue;
            return false;
        }
        return true;
    }

    private boolean containPlugin(List<Plugin> plugins, Plugin expect) {
        for (Plugin plugin : plugins) {
            if (!MetadataUtil.isPluginEquals(plugin, expect)) continue;
            return true;
        }
        return false;
    }
}

