/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.MUtils;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;

public class DefaultMetadataHelper
extends AbstractMetadataHelper {
    private final MavenRepository repository;
    private final DeleteOperation operation;

    public DefaultMetadataHelper(Logger logger, MavenRepository repository) {
        this(logger, repository, DeleteOperation.MOVE_TO_TRASH);
    }

    public DefaultMetadataHelper(Logger logger, MavenRepository repository, DeleteOperation operation) {
        super(logger);
        this.repository = repository;
        this.operation = operation;
    }

    @Override
    public void store(String content, String path) throws IOException {
        StringContentLocator contentLocator = new StringContentLocator(content);
        this.putStorageItem(path, contentLocator);
    }

    @Override
    public void remove(String path) throws IOException {
        this.deleteStorageItem(path);
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.repository.getLocalStorage().containsItem(this.repository, new ResourceStoreRequest(path, true));
    }

    @Override
    public InputStream retrieveContent(String path) throws IOException {
        AbstractStorageItem item = this.getStorageItem(path, false);
        if (item instanceof StorageFileItem) {
            return ((StorageFileItem)((Object)item)).getInputStream();
        }
        return null;
    }

    @Override
    protected boolean shouldBuildChecksum(String path) {
        if (!super.shouldBuildChecksum(path)) {
            return false;
        }
        try {
            if (this.getStorageItem(path, true).isVirtual()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        try {
            String checksumFileContent = MUtils.readDigestFromStream(((StorageFileItem)((Object)this.getStorageItem(path + ".sha1", true))).getInputStream());
            String originalFileChecksum = this.buildSh1(path);
            return !StringUtils.equals((String)checksumFileContent, (String)originalFileChecksum);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    @Override
    public String buildMd5(String path) throws IOException {
        return this.getStorageItem(path, true).getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY);
    }

    @Override
    public String buildSh1(String path) throws IOException {
        return this.getStorageItem(path, true).getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
    }

    private AbstractStorageItem getStorageItem(String path, boolean localOnly) throws IOException {
        try {
            return this.repository.getLocalStorage().retrieveItem(this.repository, new ResourceStoreRequest(path, localOnly));
        }
        catch (ItemNotFoundException e) {
            FileNotFoundException exception = new FileNotFoundException("Item not found!");
            exception.initCause(e);
            throw exception;
        }
    }

    private void putStorageItem(String path, ContentLocator contentLocator) throws IOException {
        try {
            ResourceStoreRequest req = new ResourceStoreRequest(path);
            DefaultStorageFileItem mdFile = new DefaultStorageFileItem(this.repository, req, true, true, contentLocator);
            this.repository.storeItem(false, mdFile);
            this.repository.removeFromNotFoundCache(req);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void deleteStorageItem(String path) throws IOException {
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(path, true);
            request.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)this.operation);
            this.repository.deleteItem(false, request);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected GavCalculator getGavCalculator() {
        return this.repository.getGavCalculator();
    }
}

