/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddVersionOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.StringOperand;

public class ArtifactDirMetadataProcessor
extends AbstractMetadataProcessor {
    public ArtifactDirMetadataProcessor(AbstractMetadataHelper metadataHelper) {
        super(metadataHelper);
    }

    @Override
    public void processMetadata(String path) throws IOException {
        Metadata md = this.createMetadata(path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MetadataBuilder.write(md, outputStream);
        String mdString = outputStream.toString();
        outputStream.close();
        this.metadataHelper.store(mdString, path + "/maven-metadata.xml");
    }

    private Metadata createMetadata(String path) throws IOException {
        try {
            Metadata md = new Metadata();
            md.setGroupId(this.calculateGroupId(path));
            md.setArtifactId(this.calculateArtifactId(path));
            this.versioning(md, this.metadataHelper.gaData.get(path));
            ModelVersionUtility.setModelVersion(md, ModelVersionUtility.LATEST_MODEL_VERSION);
            return md;
        }
        catch (MetadataException e) {
            throw new IOException(e);
        }
    }

    private String calculateGroupId(String path) {
        return path.substring(1, path.lastIndexOf(47)).replace('/', '.');
    }

    private String calculateArtifactId(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    @Override
    public boolean shouldProcessMetadata(String path) {
        Collection<String> versions = this.metadataHelper.gaData.get(path);
        return versions != null && !versions.isEmpty();
    }

    void versioning(Metadata metadata, Collection<String> versions) throws MetadataException {
        ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>();
        for (String version : versions) {
            ops.add(new AddVersionOperation(new StringOperand(ModelVersionUtility.LATEST_MODEL_VERSION, version)));
        }
        MetadataBuilder.changeMetadata(metadata, ops);
    }

    @Override
    public void postProcessMetadata(String path) {
        this.metadataHelper.gaData.remove(path);
    }

    @Override
    protected boolean isMetadataCorrect(Metadata oldMd, String path) throws IOException {
        Metadata md = this.createMetadata(path);
        if (oldMd.getVersioning().getRelease() == null) {
            oldMd.getVersioning().setRelease("");
        }
        if (md.getVersioning().getRelease() == null) {
            md.getVersioning().setRelease("");
        }
        if (oldMd.getVersioning().getLatest() == null) {
            return false;
        }
        if (oldMd.getVersioning().getVersions() == null) {
            return false;
        }
        return oldMd.getArtifactId().equals(md.getArtifactId()) && oldMd.getGroupId().equals(md.getGroupId()) && oldMd.getVersioning().getLatest().equals(md.getVersioning().getLatest()) && oldMd.getVersioning().getRelease().equals(md.getVersioning().getRelease()) && oldMd.getVersioning().getVersions().equals(md.getVersioning().getVersions());
    }
}

