/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;

public abstract class AbstractMetadataProcessor {
    protected static final String METADATA_SUFFIX = "/maven-metadata.xml";
    protected AbstractMetadataHelper metadataHelper;

    public AbstractMetadataProcessor(AbstractMetadataHelper metadataHelper) {
        this.metadataHelper = metadataHelper;
    }

    public boolean process(String path) throws IOException {
        if (!this.shouldProcessMetadata(path)) {
            return false;
        }
        Metadata oldMetadata = null;
        if (this.isMetadataExisted(path)) {
            oldMetadata = this.readMetadata(path);
            if (oldMetadata != null && this.isMetadataCorrect(oldMetadata, path)) {
                this.postProcessMetadata(path);
                return true;
            }
            this.removedMetadata(path);
        }
        this.processMetadata(path, oldMetadata);
        this.postProcessMetadata(path);
        this.buildMetadataChecksum(path);
        return true;
    }

    protected boolean isMetadataExisted(String path) throws IOException {
        return this.metadataHelper.exists(path + METADATA_SUFFIX);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Metadata readMetadata(String path) throws IOException {
        try (InputStream mdStream = this.metadataHelper.retrieveContent(path + METADATA_SUFFIX);){
            Metadata md;
            Metadata metadata = md = MetadataBuilder.read(mdStream);
            return metadata;
        }
        catch (IOException e) {
            if (this.metadataHelper.logger.isDebugEnabled()) {
                this.metadataHelper.logger.info("Failed to parse metadata from '" + path + "'", (Throwable)e);
                return null;
            }
            this.metadataHelper.logger.info("Failed to parse metadata from '" + path + "'");
            return null;
        }
    }

    protected void removedMetadata(String path) throws IOException {
        this.metadataHelper.remove(path + METADATA_SUFFIX);
    }

    protected void buildMetadataChecksum(String path) throws IOException {
        this.metadataHelper.rebuildChecksum(path + METADATA_SUFFIX);
    }

    protected abstract boolean isMetadataCorrect(Metadata var1, String var2) throws IOException;

    protected abstract boolean shouldProcessMetadata(String var1);

    protected void processMetadata(String path) throws IOException {
    }

    protected void processMetadata(String path, Metadata oldMetadata) throws IOException {
        this.processMetadata(path);
    }

    protected abstract void postProcessMetadata(String var1);
}

