/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.slf4j.Logger;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.gav.M2ArtifactRecognizer;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.ArtifactDirMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.GroupDirMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.ObsoleteMetadataProcessor;
import org.sonatype.nexus.proxy.maven.metadata.VersionDirMetadataProcessor;

public abstract class AbstractMetadataHelper {
    static final String MD5_SUFFIX = ".md5";
    static final String SHA1_SUFFIX = ".sha1";
    static final String METADATA_SUFFIX = "/maven-metadata.xml";
    static final String APPROPRIATE_GAV_PATTERN = "^[\\d\\w\\.-]*$";
    protected Logger logger;
    Map<String, Collection<Plugin>> gData = new HashMap<String, Collection<Plugin>>();
    Map<String, Collection<String>> gaData = new HashMap<String, Collection<String>>();
    Map<String, Collection<String>> gavData = new HashMap<String, Collection<String>>();
    private Collection<AbstractMetadataProcessor> metadataProcessors;

    public AbstractMetadataHelper(Logger logger) {
        this.logger = logger;
        this.metadataProcessors = new ArrayList<AbstractMetadataProcessor>(4);
        this.metadataProcessors.add(new VersionDirMetadataProcessor(this));
        this.metadataProcessors.add(new ArtifactDirMetadataProcessor(this));
        this.metadataProcessors.add(new GroupDirMetadataProcessor(this));
        this.metadataProcessors.add(new ObsoleteMetadataProcessor(this));
    }

    public void onDirEnter(String path) throws IOException {
    }

    public void onDirExit(String path) throws IOException {
        for (AbstractMetadataProcessor metadataProcessor : this.metadataProcessors) {
            if (metadataProcessor.process(path)) break;
        }
    }

    public void processFile(String path) throws IOException {
        if (this.isObsoleteChecksum(path)) {
            this.remove(path);
            return;
        }
        this.rebuildChecksum(path);
        if (!M2ArtifactRecognizer.isMetadata(path)) {
            this.updateMavenInfo(path);
        }
    }

    private boolean isObsoleteChecksum(String path) throws IOException {
        if (!this.isChecksumFile(path)) {
            return false;
        }
        String originalPath = path.substring(0, path.lastIndexOf(46));
        return !this.exists(originalPath);
    }

    private String getName(String path) {
        int pos = path.lastIndexOf(47);
        if (pos == -1) {
            return path;
        }
        return path.substring(pos + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMavenInfo(String path) throws IOException {
        String g = null;
        String a = null;
        String v = null;
        String n = null;
        n = path.substring(path.lastIndexOf(47) + 1);
        Gav gav = this.getGavCalculator().pathToGav(path);
        if (gav != null) {
            g = gav.getGroupId();
            a = gav.getArtifactId();
            v = gav.getBaseVersion();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unable to parse good GAV values. Path: '" + path + "'. GAV: '" + g + ":" + a + ":" + v + "'");
        }
        Model model = null;
        if (path.endsWith("pom")) {
            XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)this.retrieveContent(path));
            MavenXpp3Reader xpp3 = new MavenXpp3Reader();
            try {
                String mv;
                model = xpp3.read((Reader)reader);
                String mg = model.getGroupId() == null ? model.getParent().getGroupId() : model.getGroupId();
                String ma = model.getArtifactId();
                String string = mv = model.getVersion() == null ? model.getParent().getVersion() : model.getVersion();
                if (!this.isInpropriateValue(mg)) {
                    g = mg;
                }
                if (!this.isInpropriateValue(ma)) {
                    a = ma;
                }
                if (!this.isInpropriateValue(mv)) {
                    v = mv;
                }
            }
            catch (Exception e) {
                this.logger.debug("Unable to parse POM model from '" + path + "'.", (Throwable)e);
            }
            finally {
                reader.close();
                reader = null;
            }
        }
        if (g == null || a == null || v == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve gav for '" + path + "'. g:" + g + " a:" + a + " v:" + v);
            }
            return;
        }
        if (path.endsWith("pom")) {
            String gaPath;
            if (model != null && model.getPackaging().equals("maven-plugin")) {
                String gPath;
                Plugin plugin = new Plugin();
                plugin.setArtifactId(a);
                plugin.setPrefix(this.getPluginPrefix(a, path));
                if (!StringUtils.isEmpty((String)model.getName())) {
                    plugin.setName(model.getName());
                }
                if (this.gData.get(gPath = "/" + g.replace('.', '/')) == null) {
                    this.gData.put(gPath, new ArrayList());
                }
                this.gData.get(gPath).add(plugin);
            }
            if (this.gaData.get(gaPath = "/" + g.replace('.', '/') + "/" + a) == null) {
                this.gaData.put(gaPath, new ArrayList());
            }
            this.gaData.get(gaPath).add(v);
        }
        if (v.endsWith("SNAPSHOT")) {
            String gavPath = "/" + g.replace('.', '/') + "/" + a + "/" + v;
            if (this.gavData.get(gavPath) == null) {
                this.gavData.put(gavPath, new ArrayList());
            }
            this.gavData.get(gavPath).add(n);
        }
    }

    private boolean isInpropriateValue(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return true;
        }
        return !value.matches(APPROPRIATE_GAV_PATTERN);
    }

    private String getPluginPrefix(String artifactId, String path) {
        String prefix;
        block18: {
            String jarPath = path.replace(".pom", ".jar");
            prefix = null;
            try {
                if (!this.exists(jarPath)) break block18;
                try (ZipInputStream zip = new ZipInputStream(this.retrieveContent(jarPath));){
                    ZipEntry entry;
                    while ((entry = zip.getNextEntry()) != null) {
                        if (!entry.isDirectory() && entry.getName().equals("META-INF/maven/plugin.xml")) {
                            XmlPlexusConfiguration plexusConfig = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)new InputStreamReader(zip)));
                            prefix = plexusConfig.getChild("goalPrefix").getValue();
                            zip.closeEntry();
                            break;
                        }
                        zip.closeEntry();
                    }
                }
            }
            catch (Exception e) {
                this.logger.debug("Unable to read plugin.xml", (Throwable)e);
            }
        }
        if (prefix != null) {
            return prefix;
        }
        if ("maven-plugin-plugin".equals(artifactId)) {
            return "plugin";
        }
        return artifactId.replaceAll("-?maven-?", "").replaceAll("-?plugin-?", "");
    }

    void rebuildChecksum(String path) throws IOException {
        if (!this.exists(path)) {
            if (this.exists(path + MD5_SUFFIX)) {
                this.remove(path + MD5_SUFFIX);
            }
            if (this.exists(path + SHA1_SUFFIX)) {
                this.remove(path + SHA1_SUFFIX);
            }
            return;
        }
        if (!this.shouldBuildChecksum(path)) {
            return;
        }
        this.store(this.buildMd5(path), path + MD5_SUFFIX);
        this.store(this.buildSh1(path), path + SHA1_SUFFIX);
    }

    protected boolean shouldBuildChecksum(String path) {
        return !this.isChecksumFile(path);
    }

    protected boolean isChecksumFile(String path) {
        return this.getName(path).endsWith(MD5_SUFFIX) || this.getName(path).endsWith(SHA1_SUFFIX);
    }

    public abstract String buildMd5(String var1) throws IOException;

    public abstract String buildSh1(String var1) throws IOException;

    public abstract void store(String var1, String var2) throws IOException;

    public abstract void remove(String var1) throws IOException;

    public abstract InputStream retrieveContent(String var1) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    protected abstract GavCalculator getGavCalculator();
}

