/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.maven2;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepository;
import org.sonatype.nexus.proxy.maven.MavenRepositoryMetadataManager;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.gav.M2ArtifactRecognizer;
import org.sonatype.nexus.proxy.maven.maven2.M2RepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.maven2.M2RepositoryConfigurator;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryMetadataManager;
import org.sonatype.nexus.util.AlphanumComparator;
import org.sonatype.nexus.util.DigesterUtils;
import org.sonatype.nexus.util.io.StreamSupport;

@Named(value="maven2")
@Typed(value={Repository.class})
@Description(value="Maven2 Repository")
public class M2Repository
extends AbstractMavenRepository {
    public static final String ID = "maven2";
    private final ContentClass contentClass;
    private final GavCalculator gavCalculator;
    private final M2RepositoryConfigurator m2RepositoryConfigurator;
    private final MavenRepositoryMetadataManager mavenRepositoryMetadataManager;

    @Inject
    public M2Repository(@Named(value="maven2") ContentClass contentClass, @Named(value="maven2") GavCalculator gavCalculator, M2RepositoryConfigurator m2RepositoryConfigurator) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.gavCalculator = (GavCalculator)Preconditions.checkNotNull((Object)gavCalculator);
        this.m2RepositoryConfigurator = (M2RepositoryConfigurator)Preconditions.checkNotNull((Object)m2RepositoryConfigurator);
        this.mavenRepositoryMetadataManager = new MavenRepositoryMetadataManager(this);
    }

    @Override
    public RepositoryMetadataManager getRepositoryMetadataManager() {
        return this.mavenRepositoryMetadataManager;
    }

    @Override
    protected M2RepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (M2RepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    @Override
    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<M2RepositoryConfiguration>(){

            @Override
            public M2RepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new M2RepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    @Override
    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    protected Configurator getConfigurator() {
        return this.m2RepositoryConfigurator;
    }

    @Override
    public boolean isMavenMetadataPath(String path) {
        return M2ArtifactRecognizer.isMetadata(path);
    }

    @Override
    public boolean isMavenArtifactChecksumPath(String path) {
        return M2ArtifactRecognizer.isChecksum(path);
    }

    @Override
    public boolean shouldServeByPolicies(ResourceStoreRequest request) {
        if (M2ArtifactRecognizer.isMetadata(request.getRequestPath())) {
            if (M2ArtifactRecognizer.isSnapshot(request.getRequestPath())) {
                return RepositoryPolicy.SNAPSHOT.equals((Object)this.getRepositoryPolicy());
            }
            return true;
        }
        Gav gav = this.getGavCalculator().pathToGav(request.getRequestPath());
        if (gav == null) {
            return true;
        }
        if (gav.isSnapshot()) {
            return RepositoryPolicy.SNAPSHOT.equals((Object)this.getRepositoryPolicy());
        }
        return RepositoryPolicy.RELEASE.equals((Object)this.getRepositoryPolicy());
    }

    @Override
    public AbstractStorageItem doCacheItem(AbstractStorageItem item) throws LocalStorageException {
        block16: {
            if (this.isCleanseRepositoryMetadata() && item instanceof StorageFileItem && M2ArtifactRecognizer.isMetadata(item.getPath())) {
                StorageFileItem mdFile = (StorageFileItem)((Object)item);
                ByteArrayInputStream backup = null;
                ByteArrayOutputStream backup1 = new ByteArrayOutputStream();
                try {
                    try (InputStream orig = mdFile.getInputStream();){
                        StreamSupport.copy(orig, backup1, StreamSupport.BUFFER_SIZE);
                    }
                    backup = new ByteArrayInputStream(backup1.toByteArray());
                    MetadataXpp3Reader metadataReader = new MetadataXpp3Reader();
                    InputStreamReader isr = new InputStreamReader(backup);
                    Metadata imd = metadataReader.read((Reader)isr);
                    imd = this.cleanseMetadataForRepository(RepositoryPolicy.SNAPSHOT.equals((Object)this.getRepositoryPolicy()), imd);
                    MetadataXpp3Writer metadataWriter = new MetadataXpp3Writer();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(bos);
                    metadataWriter.write((Writer)osw, imd);
                    mdFile.setContentLocator(new ByteArrayContentLocator(bos.toByteArray(), mdFile.getMimeType()));
                }
                catch (Exception e) {
                    this.log.error("Exception during repository metadata cleansing.", (Throwable)e);
                    if (backup == null) break block16;
                    backup.reset();
                    mdFile.setContentLocator(new ByteArrayContentLocator(backup1.toByteArray(), mdFile.getMimeType()));
                }
            }
        }
        return super.doCacheItem(item);
    }

    @Override
    protected boolean isOld(StorageItem item) {
        if (M2ArtifactRecognizer.isMetadata(item.getPath())) {
            return this.isOld(this.getMetadataMaxAge(), item);
        }
        Gav gav = this.getGavCalculator().pathToGav(item.getPath());
        if (gav != null && gav.isSnapshot()) {
            return this.isOld(this.getArtifactMaxAge(), item);
        }
        if (gav == null) {
            return super.isOld(item);
        }
        return this.isOld(this.getArtifactMaxAge(), item);
    }

    protected Metadata cleanseMetadataForRepository(boolean snapshot, Metadata metadata) {
        List versions = metadata.getVersioning().getVersions();
        Iterator iversion = versions.iterator();
        while (iversion.hasNext()) {
            if ((!snapshot || Gav.isSnapshot((String)iversion.next())) && (snapshot || !Gav.isSnapshot((String)iversion.next()))) continue;
            iversion.remove();
        }
        metadata.getVersioning().setLatest(this.getLatestVersion(metadata.getVersioning().getVersions()));
        if (snapshot) {
            metadata.getVersioning().setRelease(null);
        } else {
            metadata.getVersioning().setRelease(metadata.getVersioning().getLatest());
        }
        return metadata;
    }

    public String getLatestVersion(List<String> versions) {
        Collections.sort(versions, new AlphanumComparator());
        return versions.get(versions.size() - 1);
    }

    @Override
    protected void enforceWritePolicy(ResourceStoreRequest request, Action action) throws IllegalRequestException {
        Gav gav;
        if (!(M2ArtifactRecognizer.isMetadata(request.getRequestPath()) || (gav = this.getGavCalculator().pathToGav(request.getRequestPath())) != null && gav.isSnapshot())) {
            super.enforceWritePolicy(request, action);
        }
    }

    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        boolean remoteCall = request.getRequestContext().containsKey("request.address");
        String userAgent = (String)request.getRequestContext().get("request.agent");
        if (remoteCall && null != userAgent) {
            ModelVersionUtility.Version userSupportedVersion = this.getClientSupportedVersion(userAgent);
            if (M2ArtifactRecognizer.isMetadata(request.getRequestPath()) && userSupportedVersion != null && !ModelVersionUtility.LATEST_MODEL_VERSION.equals((Object)userSupportedVersion)) {
                StorageFileItem mdItem;
                if (M2ArtifactRecognizer.isChecksum(request.getRequestPath())) {
                    String path = request.getRequestPath();
                    if (request.getRequestPath().endsWith(".md5")) {
                        path = path.substring(0, path.length() - 4);
                    } else if (request.getRequestPath().endsWith(".sha1")) {
                        path = path.substring(0, path.length() - 5);
                    }
                    ResourceStoreRequest mdRequest = new ResourceStoreRequest(path, request.isRequestLocalOnly(), request.isRequestRemoteOnly());
                    mdRequest.getRequestContext().setParentContext(request.getRequestContext());
                    mdItem = (StorageFileItem)super.retrieveItem(false, mdRequest);
                } else {
                    mdItem = (StorageFileItem)super.doRetrieveItem(request);
                }
                try {
                    byte[] content;
                    Metadata metadata;
                    try (InputStream inputStream = mdItem.getInputStream();){
                        metadata = MetadataBuilder.read(inputStream);
                    }
                    ModelVersionUtility.Version requiredVersion = this.getClientSupportedVersion(userAgent);
                    ModelVersionUtility.Version metadataVersion = ModelVersionUtility.getModelVersion(metadata);
                    if (requiredVersion == null || requiredVersion.equals((Object)metadataVersion)) {
                        return super.doRetrieveItem(request);
                    }
                    ModelVersionUtility.setModelVersion(metadata, requiredVersion);
                    ByteArrayOutputStream mdOutput = new ByteArrayOutputStream();
                    MetadataBuilder.write(metadata, mdOutput);
                    if (M2ArtifactRecognizer.isChecksum(request.getRequestPath())) {
                        String digest = request.getRequestPath().endsWith(".md5") ? DigesterUtils.getMd5Digest(mdOutput.toByteArray()) : DigesterUtils.getSha1Digest(mdOutput.toByteArray());
                        content = (digest + '\n').getBytes("UTF-8");
                    } else {
                        content = mdOutput.toByteArray();
                    }
                    String mimeType = this.getMimeSupport().guessMimeTypeFromPath(this.getMimeRulesSource(), request.getRequestPath());
                    ByteArrayContentLocator contentLocator = new ByteArrayContentLocator(content, mimeType);
                    DefaultStorageFileItem result = new DefaultStorageFileItem(this, request, true, false, (ContentLocator)contentLocator);
                    result.setCreated(mdItem.getCreated());
                    result.setModified(System.currentTimeMillis());
                    return result;
                }
                catch (IOException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error("Error parsing metadata, serving as retrieved", (Throwable)e);
                    } else {
                        this.log.error("Error parsing metadata, serving as retrieved: " + e.getMessage());
                    }
                    return super.doRetrieveItem(request);
                }
            }
        }
        return super.doRetrieveItem(request);
    }

    protected ModelVersionUtility.Version getClientSupportedVersion(String userAgent) {
        if (userAgent == null) {
            return null;
        }
        if (userAgent.startsWith("Apache Ivy")) {
            return ModelVersionUtility.Version.V100;
        }
        if (userAgent.startsWith("Java")) {
            return ModelVersionUtility.Version.V100;
        }
        if (userAgent.startsWith("Apache-Maven/2")) {
            return ModelVersionUtility.Version.V100;
        }
        return ModelVersionUtility.Version.V110;
    }
}

