/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.maven2;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.maven.LayoutConverterShadowRepository;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.gav.M2ArtifactRecognizer;
import org.sonatype.nexus.proxy.maven.maven2.M2LayoutedM1ShadowRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.maven2.M2LayoutedM1ShadowRepositoryConfigurator;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.ShadowRepository;

@Named(value="m1-m2-shadow")
@Typed(value={ShadowRepository.class})
@Description(value="Maven1 to Maven2")
public class M2LayoutedM1ShadowRepository
extends LayoutConverterShadowRepository {
    public static final String ID = "m1-m2-shadow";
    private final ContentClass contentClass;
    private final ContentClass masterContentClass;
    private final M2LayoutedM1ShadowRepositoryConfigurator m2LayoutedM1ShadowRepositoryConfigurator;

    @Inject
    public M2LayoutedM1ShadowRepository(@Named(value="maven2") ContentClass contentClass, @Named(value="maven1") ContentClass masterContentClass, M2LayoutedM1ShadowRepositoryConfigurator m2LayoutedM1ShadowRepositoryConfigurator) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.masterContentClass = (ContentClass)Preconditions.checkNotNull((Object)masterContentClass);
        this.m2LayoutedM1ShadowRepositoryConfigurator = (M2LayoutedM1ShadowRepositoryConfigurator)Preconditions.checkNotNull((Object)m2LayoutedM1ShadowRepositoryConfigurator);
    }

    @Override
    protected M2LayoutedM1ShadowRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (M2LayoutedM1ShadowRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    @Override
    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<M2LayoutedM1ShadowRepositoryConfiguration>(){

            @Override
            public M2LayoutedM1ShadowRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new M2LayoutedM1ShadowRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.getM2GavCalculator();
    }

    @Override
    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    @Override
    public ContentClass getMasterRepositoryContentClass() {
        return this.masterContentClass;
    }

    @Override
    protected Configurator getConfigurator() {
        return this.m2LayoutedM1ShadowRepositoryConfigurator;
    }

    @Override
    protected List<String> transformMaster2Shadow(String path) {
        return this.transformM1toM2(path);
    }

    @Override
    protected List<String> transformShadow2Master(String path) {
        return this.transformM2toM1(path, Collections.singletonList("ejbs"));
    }

    @Override
    public boolean isMavenMetadataPath(String path) {
        return M2ArtifactRecognizer.isMetadata(path);
    }
}

