/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.maven2;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEvent;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageCompositeFileItem;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageCompositeFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.AbstractMavenGroupRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MavenRepositoryMetadataValidationEventFailed;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.gav.M2ArtifactRecognizer;
import org.sonatype.nexus.proxy.maven.maven2.M2GroupRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.maven2.M2GroupRepositoryConfigurator;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.NexusMergeOperation;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.util.DigesterUtils;

@Named(value="maven2")
@Typed(value={GroupRepository.class})
@Description(value="Maven2 Repository Group")
public class M2GroupRepository
extends AbstractMavenGroupRepository {
    public static final String ID = "maven2";
    private final ContentClass contentClass;
    private final GavCalculator gavCalculator;
    private final M2GroupRepositoryConfigurator m2GroupRepositoryConfigurator;

    @Inject
    public M2GroupRepository(@Named(value="maven2") ContentClass contentClass, @Named(value="maven2") GavCalculator gavCalculator, M2GroupRepositoryConfigurator m2GroupRepositoryConfigurator) {
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.gavCalculator = (GavCalculator)Preconditions.checkNotNull((Object)gavCalculator);
        this.m2GroupRepositoryConfigurator = (M2GroupRepositoryConfigurator)Preconditions.checkNotNull((Object)m2GroupRepositoryConfigurator);
    }

    @Override
    protected M2GroupRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (M2GroupRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    protected CRepositoryExternalConfigurationHolderFactory<M2GroupRepositoryConfiguration> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<M2GroupRepositoryConfiguration>(){

            @Override
            public M2GroupRepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new M2GroupRepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    @Override
    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    protected Configurator getConfigurator() {
        return this.m2GroupRepositoryConfigurator;
    }

    @Override
    public boolean isMavenMetadataPath(String path) {
        return M2ArtifactRecognizer.isMetadata(path);
    }

    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (M2ArtifactRecognizer.isMetadata(request.getRequestPath()) && !M2ArtifactRecognizer.isChecksum(request.getRequestPath())) {
            try {
                return this.doRetrieveMetadata(request);
            }
            catch (UnsupportedStorageOperationException e) {
                throw new LocalStorageException(e);
            }
        }
        return super.doRetrieveItem(request);
    }

    private Metadata parseMetadata(StorageFileItem fileItem) throws IOException, MetadataException {
        Metadata metadata;
        try (InputStream inputStream = fileItem.getInputStream();){
            metadata = MetadataBuilder.read(inputStream);
        }
        MavenRepository repo = fileItem.getRepositoryItemUid().getRepository().adaptToFacet(MavenRepository.class);
        RepositoryPolicy policy = repo.getRepositoryPolicy();
        if (metadata != null && metadata.getVersioning() != null) {
            List versions = metadata.getVersioning().getVersions();
            if (RepositoryPolicy.RELEASE.equals((Object)policy)) {
                metadata.getVersioning().setSnapshot(null);
                String latest = this.filterMetadata(versions, false);
                metadata.getVersioning().setLatest(latest);
            } else if (RepositoryPolicy.SNAPSHOT.equals((Object)policy)) {
                metadata.getVersioning().setRelease(null);
                String latest = this.filterMetadata(versions, true);
                metadata.getVersioning().setLatest(latest);
            }
        }
        return metadata;
    }

    private String filterMetadata(List<String> versions, boolean allowSnapshot) {
        String latest = null;
        Iterator<String> it = versions.iterator();
        while (it.hasNext()) {
            String version = it.next();
            if (allowSnapshot ^ Gav.isSnapshot(version)) {
                it.remove();
                continue;
            }
            latest = version;
        }
        return latest;
    }

    private StorageItem doRetrieveMetadata(ResourceStoreRequest request) throws StorageException, IllegalOperationException, UnsupportedStorageOperationException, ItemNotFoundException {
        List<StorageItem> items = this.doRetrieveItems(request);
        if (items.isEmpty()) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Metadata %s not found in any of the members of %s.", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(this)));
        }
        if (!this.isMergeMetadata()) {
            return items.get(0);
        }
        ArrayList<Metadata> existingMetadatas = new ArrayList<Metadata>();
        try {
            for (StorageItem item : items) {
                if (!(item instanceof StorageFileItem)) break;
                StorageFileItem fileItem = (StorageFileItem)item;
                try {
                    existingMetadatas.add(this.parseMetadata(fileItem));
                }
                catch (IOException e) {
                    this.log.warn("IOException during parse of metadata UID=\"" + fileItem.getRepositoryItemUid().toString() + "\", will be skipped from aggregation!", (Throwable)e);
                    this.eventBus().post((Object)this.newMetadataFailureEvent(fileItem, "Invalid metadata served by repository. If repository is proxy, please check out what is it serving!"));
                }
                catch (MetadataException e) {
                    this.log.warn("Metadata exception during parse of metadata from UID=\"" + fileItem.getRepositoryItemUid().toString() + "\", will be skipped from aggregation!", (Throwable)e);
                    this.eventBus().post((Object)this.newMetadataFailureEvent(fileItem, "Invalid metadata served by repository. If repository is proxy, please check out what is it serving!"));
                }
            }
            if (existingMetadatas.isEmpty()) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Metadata %s not parseable in any of the members of %s.", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(this)));
            }
            Metadata result = (Metadata)existingMetadatas.get(0);
            if (existingMetadatas.size() > 1) {
                ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>();
                for (int i = 1; i < existingMetadatas.size(); ++i) {
                    ops.add(new NexusMergeOperation(new MetadataOperand((Metadata)existingMetadatas.get(i))));
                }
                Collection<MetadataException> metadataExceptions = MetadataBuilder.changeMetadataIgnoringFailures(result, ops);
                if (metadataExceptions != null && !metadataExceptions.isEmpty()) {
                    for (MetadataException metadataException : metadataExceptions) {
                        this.log.warn("Ignored exception during M2 metadata merging: " + metadataException.getMessage() + " (request " + request.getRequestPath() + ")", (Throwable)metadataException);
                    }
                }
            }
            ByteArrayOutputStream resultOutputStream = new ByteArrayOutputStream();
            MetadataBuilder.write(result, resultOutputStream);
            StorageCompositeFileItem item = this.createMergedMetadataItem(request, resultOutputStream.toByteArray(), items);
            String md5Digest = DigesterUtils.getMd5Digest(resultOutputStream.toByteArray());
            String sha1Digest = DigesterUtils.getSha1Digest(resultOutputStream.toByteArray());
            this.storeMergedMetadataItemDigest(request, md5Digest, items, "MD5");
            this.storeMergedMetadataItemDigest(request, sha1Digest, items, "SHA1");
            resultOutputStream.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Item for path " + request.toString() + " merged from " + Integer.toString(items.size()) + " found items.");
            }
            return item;
        }
        catch (IOException e) {
            throw new LocalStorageException("Got IOException during M2 metadata merging.", e);
        }
        catch (MetadataException e) {
            throw new LocalStorageException("Got MetadataException during M2 metadata merging.", e);
        }
    }

    protected void storeMergedMetadataItemDigest(ResourceStoreRequest request, String digest, List<StorageItem> sources, String algorithm) throws IOException, UnsupportedStorageOperationException, IllegalOperationException {
        String digestFileName = request.getRequestPath() + "." + algorithm.toLowerCase();
        String mimeType = this.getMimeSupport().guessMimeTypeFromPath(this.getMimeRulesSource(), digestFileName);
        byte[] bytes = (digest + '\n').getBytes("UTF-8");
        ByteArrayContentLocator contentLocator = new ByteArrayContentLocator(bytes, mimeType);
        ResourceStoreRequest req = new ResourceStoreRequest(digestFileName);
        req.getRequestContext().setParentContext(request.getRequestContext());
        DefaultStorageFileItem digestFileItem = new DefaultStorageFileItem(this, req, true, false, (ContentLocator)contentLocator);
        this.storeItem(false, digestFileItem);
    }

    protected StorageCompositeFileItem createMergedMetadataItem(ResourceStoreRequest request, byte[] content, List<StorageItem> sources) {
        String mimeType = this.getMimeSupport().guessMimeTypeFromPath(this.getMimeRulesSource(), "maven-metadata.xml");
        ByteArrayContentLocator contentLocator = new ByteArrayContentLocator(content, mimeType);
        DefaultStorageCompositeFileItem result = new DefaultStorageCompositeFileItem(this, request, true, false, contentLocator, sources);
        result.setCreated(this.getNewestCreatedDate(sources));
        result.setModified(result.getCreated());
        return result;
    }

    private long getNewestCreatedDate(List<StorageItem> sources) {
        long result = 0L;
        for (StorageItem source : sources) {
            result = Math.max(result, source.getCreated());
        }
        return result;
    }

    private RepositoryItemValidationEvent newMetadataFailureEvent(StorageFileItem item, String msg) {
        return new MavenRepositoryMetadataValidationEventFailed(this, item, msg);
    }
}

