/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.maven1;

import com.google.common.base.Preconditions;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Description;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.gav.M1ArtifactRecognizer;
import org.sonatype.nexus.proxy.maven.maven1.M1RepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.maven1.M1RepositoryConfigurator;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.repository.Repository;

@Deprecated
@Named(value="maven1")
@Typed(value={Repository.class})
@Description(value="Maven1 Repository")
public class M1Repository
extends AbstractMavenRepository {
    public static final String ID = "maven1";
    private final ContentClass contentClass;
    private final GavCalculator gavCalculator;
    private final M1RepositoryConfigurator m1RepositoryConfigurator;

    @Inject
    public M1Repository(@Named(value="maven1") ContentClass contentClass, @Named(value="maven1") GavCalculator gavCalculator, M1RepositoryConfigurator m1RepositoryConfigurator) {
        this.gavCalculator = (GavCalculator)Preconditions.checkNotNull((Object)gavCalculator);
        this.contentClass = (ContentClass)Preconditions.checkNotNull((Object)contentClass);
        this.m1RepositoryConfigurator = (M1RepositoryConfigurator)Preconditions.checkNotNull((Object)m1RepositoryConfigurator);
    }

    @Override
    public M1RepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (M1RepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    protected CRepositoryExternalConfigurationHolderFactory<M1RepositoryConfiguration> getExternalConfigurationHolderFactory() {
        return new CRepositoryExternalConfigurationHolderFactory<M1RepositoryConfiguration>(){

            @Override
            public M1RepositoryConfiguration createExternalConfigurationHolder(CRepository config) {
                return new M1RepositoryConfiguration((Xpp3Dom)config.getExternalConfiguration());
            }
        };
    }

    @Override
    public ContentClass getRepositoryContentClass() {
        return this.contentClass;
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    protected Configurator getConfigurator() {
        return this.m1RepositoryConfigurator;
    }

    @Override
    public boolean isMavenMetadataPath(String path) {
        return M1ArtifactRecognizer.isMetadata(path);
    }

    @Override
    public boolean isMavenArtifactChecksumPath(String path) {
        return M1ArtifactRecognizer.isChecksum(path);
    }

    @Override
    public boolean shouldServeByPolicies(ResourceStoreRequest request) {
        if (M1ArtifactRecognizer.isMetadata(request.getRequestPath())) {
            if (M1ArtifactRecognizer.isSnapshot(request.getRequestPath())) {
                return RepositoryPolicy.SNAPSHOT.equals((Object)this.getRepositoryPolicy());
            }
            return true;
        }
        Gav gav = this.getGavCalculator().pathToGav(request.getRequestPath());
        if (gav == null) {
            return true;
        }
        if (gav.isSnapshot()) {
            return RepositoryPolicy.SNAPSHOT.equals((Object)this.getRepositoryPolicy());
        }
        return RepositoryPolicy.RELEASE.equals((Object)this.getRepositoryPolicy());
    }

    @Override
    protected boolean isOld(StorageItem item) {
        if (M1ArtifactRecognizer.isMetadata(item.getPath())) {
            return this.isOld(this.getMetadataMaxAge(), item);
        }
        if (M1ArtifactRecognizer.isSnapshot(item.getPath())) {
            return this.isOld(this.getArtifactMaxAge(), item);
        }
        Gav gav = this.gavCalculator.pathToGav(item.getPath());
        if (gav == null) {
            return super.isOld(item);
        }
        return this.isOld(this.getArtifactMaxAge(), item);
    }

    @Override
    protected void enforceWritePolicy(ResourceStoreRequest request, Action action) throws IllegalRequestException {
        if (!M1ArtifactRecognizer.isMetadata(request.getRequestPath()) && !M1ArtifactRecognizer.isSnapshot(request.getRequestPath())) {
            super.enforceWritePolicy(request, action);
        }
    }
}

