/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import org.slf4j.Logger;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.metadata.AbstractMetadataHelper;
import org.sonatype.nexus.proxy.maven.metadata.DefaultMetadataHelper;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;

public class RecreateMavenMetadataWalkerProcessor
extends AbstractWalkerProcessor {
    private boolean isHostedRepo;
    private MavenRepository repository;
    private AbstractMetadataHelper mdHelper;
    private final Logger logger;
    private DeleteOperation deleteOperation;

    public RecreateMavenMetadataWalkerProcessor(Logger logger) {
        this.logger = logger;
    }

    public RecreateMavenMetadataWalkerProcessor(Logger logger, DeleteOperation operation) {
        this.logger = logger;
        this.deleteOperation = operation;
    }

    @Override
    public void beforeWalk(WalkerContext context) throws Exception {
        this.isHostedRepo = false;
        MavenRepository mavenRepository = this.repository = context.getRepository() instanceof MavenRepository ? (MavenRepository)context.getRepository() : null;
        if (this.repository != null) {
            this.mdHelper = new DefaultMetadataHelper(this.logger, this.repository, this.deleteOperation);
            this.isHostedRepo = this.repository.getRepositoryKind().isFacetAvailable(HostedRepository.class);
        }
        this.setActive(this.isHostedRepo);
    }

    @Override
    public void onCollectionEnter(WalkerContext context, StorageCollectionItem coll) {
        try {
            this.mdHelper.onDirEnter(coll.getPath());
        }
        catch (Exception e) {
            this.logger.warn("Error occurred while entering collection '" + coll.getPath() + "'.", (Throwable)e);
        }
    }

    @Override
    public void processItem(WalkerContext context, StorageItem item) {
        if (item instanceof StorageFileItem) {
            try {
                this.mdHelper.processFile(item.getPath());
            }
            catch (Exception e) {
                this.logger.warn("Error occurred while processing item '" + item.getPath() + "'.", (Throwable)e);
            }
        }
    }

    @Override
    public void onCollectionExit(WalkerContext context, StorageCollectionItem coll) {
        try {
            this.mdHelper.onDirExit(coll.getPath());
            if (coll.list().size() == 0) {
                ResourceStoreRequest request = new ResourceStoreRequest(coll);
                if (this.deleteOperation != null) {
                    request.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)this.deleteOperation);
                }
                this.repository.deleteItem(false, request);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error occurred while existing collection '" + coll.getPath() + "'.", (Throwable)e);
        }
    }
}

