/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MetadataLocator;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

@Singleton
@Named
public class MavenRepositoryMetadataLocator
implements MetadataLocator {
    @Override
    public Gav getGavForRequest(ArtifactStoreRequest request) {
        return request.getGav();
    }

    @Override
    public Plugin extractPluginElementFromPom(ArtifactStoreRequest request) throws IOException {
        Model pom = this.retrievePom(request);
        if (!"maven-plugin".equals(pom.getPackaging())) {
            return null;
        }
        Plugin plugin = new Plugin();
        plugin.setArtifactId(pom.getArtifactId());
        plugin.setName(pom.getName());
        if ("maven-plugin-plugin".equals(pom.getArtifactId())) {
            plugin.setPrefix("plugin");
        } else {
            plugin.setPrefix(pom.getArtifactId().replaceAll("-?maven-?", "").replaceAll("-?plugin-?", ""));
        }
        return plugin;
    }

    protected Gav getPomGav(ArtifactStoreRequest request) {
        Gav pomGav = new Gav(request.getGav().getGroupId(), request.getGav().getArtifactId(), request.getGav().getVersion(), null, "pom", request.getGav().getSnapshotBuildNumber(), request.getGav().getSnapshotTimeStamp(), null, false, null, false, null);
        return pomGav;
    }

    @Override
    public String retrievePackagingFromPom(ArtifactStoreRequest request) throws IOException {
        String packaging;
        GavCalculator gavCalculator = request.getMavenRepository().getGavCalculator();
        try {
            Gav pomGav = this.getPomGav(request);
            if (pomGav == null) {
                return null;
            }
            String pomPath = gavCalculator.gavToPath(pomGav);
            request.setRequestPath(pomPath);
            StorageFileItem pomFile = (StorageFileItem)request.getMavenRepository().retrieveItem(false, request);
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)pomFile.getInputStream());){
                packaging = this.getPackaging((Reader)reader);
            }
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
        return packaging;
    }

    private String getPackaging(Reader reader) throws XmlPullParserException, IOException {
        String packaging = "jar";
        MXParser parser = new MXParser();
        parser.setInput(reader);
        boolean foundRoot = false;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("project")) {
                    foundRoot = true;
                } else if (parser.getName().equals("packaging")) {
                    if (parser.getDepth() == 2) {
                        packaging = StringUtils.trim((String)parser.nextText());
                        break;
                    }
                } else if (!foundRoot) {
                    throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", (XmlPullParser)parser, null);
                }
            }
            eventType = parser.next();
        }
        return packaging;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Model retrievePom(ArtifactStoreRequest request) throws IOException {
        try {
            Gav gav = this.getPomGav(request);
            if (gav == null) {
                return null;
            }
            String pomPath = request.getMavenRepository().getGavCalculator().gavToPath(gav);
            request.setRequestPath(pomPath);
            StorageFileItem pomFile = (StorageFileItem)request.getMavenRepository().retrieveItem(false, request);
            try (InputStream is = pomFile.getInputStream();){
                MavenXpp3Reader rd = new MavenXpp3Reader();
                Model model = rd.read(is);
                return model;
            }
            catch (XmlPullParserException e) {
                throw this.createIOExceptionWithCause(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public Metadata retrieveGAVMetadata(ArtifactStoreRequest request) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            return this.readOrCreateGAVMetadata(request, gav);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public Metadata retrieveGAMetadata(ArtifactStoreRequest request) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            return this.readOrCreateGAMetadata(request, gav);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public Metadata retrieveGMetadata(ArtifactStoreRequest request) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            return this.readOrCreateGMetadata(request, gav);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public void storeGAVMetadata(ArtifactStoreRequest request, Metadata metadata) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            this.writeGAVMetadata(request, gav, metadata);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public void storeGAMetadata(ArtifactStoreRequest request, Metadata metadata) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            this.writeGAMetadata(request, gav, metadata);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    @Override
    public void storeGMetadata(ArtifactStoreRequest request, Metadata metadata) throws IOException {
        try {
            Gav gav = this.getGavForRequest(request);
            this.writeGMetadata(request, gav, metadata);
        }
        catch (Exception e) {
            throw this.createIOExceptionWithCause(e.getMessage(), e);
        }
    }

    private IOException createIOExceptionWithCause(String message, Throwable cause) {
        IOException result = new IOException(message);
        result.initCause(cause);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata readOrCreateMetadata(RepositoryItemUid uid, ArtifactStoreRequest request) throws IllegalOperationException, IOException, MetadataException {
        Metadata result;
        block18: {
            result = null;
            String storedPath = request.getRequestPath();
            try {
                request.setRequestPath(uid.getPath());
                StorageItem item = uid.getRepository().retrieveItem(false, request);
                if (StorageFileItem.class.isAssignableFrom(item.getClass())) {
                    StorageFileItem fileItem = (StorageFileItem)item;
                    try (InputStream is = fileItem.getInputStream();){
                        result = MetadataBuilder.read(is);
                        break block18;
                    }
                }
                throw new IllegalArgumentException("The UID " + uid.toString() + " is not a file!");
            }
            catch (ItemNotFoundException e) {
                result = new Metadata();
            }
            finally {
                request.setRequestPath(storedPath);
            }
        }
        return result;
    }

    protected void writeMetadata(RepositoryItemUid uid, RequestContext ctx, Metadata md) throws IllegalOperationException, UnsupportedStorageOperationException, MetadataException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MetadataBuilder.write(md, outputStream);
        String mdString = outputStream.toString("UTF-8");
        outputStream.close();
        DefaultStorageFileItem file = new DefaultStorageFileItem(uid.getRepository(), new ResourceStoreRequest(uid.getPath()), true, true, (ContentLocator)new StringContentLocator(mdString));
        ((MavenRepository)uid.getRepository()).storeItemWithChecksums(false, file);
    }

    protected Metadata readOrCreateGAVMetadata(ArtifactStoreRequest request, Gav gav) throws IllegalOperationException, IOException, MetadataException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        Metadata result = this.readOrCreateMetadata(uid, request);
        result.setGroupId(gav.getGroupId());
        result.setArtifactId(gav.getArtifactId());
        result.setVersion(gav.getBaseVersion());
        return result;
    }

    protected Metadata readOrCreateGAMetadata(ArtifactStoreRequest request, Gav gav) throws IllegalOperationException, IOException, MetadataException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        Metadata result = this.readOrCreateMetadata(uid, request);
        result.setGroupId(gav.getGroupId());
        result.setArtifactId(gav.getArtifactId());
        result.setVersion(null);
        return result;
    }

    protected Metadata readOrCreateGMetadata(ArtifactStoreRequest request, Gav gav) throws IllegalOperationException, IOException, MetadataException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        Metadata result = this.readOrCreateMetadata(uid, request);
        result.setGroupId(null);
        result.setArtifactId(null);
        result.setVersion(null);
        return result;
    }

    protected void writeGAVMetadata(ArtifactStoreRequest request, Gav gav, Metadata md) throws UnsupportedStorageOperationException, IllegalOperationException, MetadataException, IOException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        this.writeMetadata(uid, request.getRequestContext(), md);
    }

    protected void writeGAMetadata(ArtifactStoreRequest request, Gav gav, Metadata md) throws UnsupportedStorageOperationException, IllegalOperationException, MetadataException, IOException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        this.writeMetadata(uid, request.getRequestContext(), md);
    }

    protected void writeGMetadata(ArtifactStoreRequest request, Gav gav, Metadata md) throws UnsupportedStorageOperationException, IllegalOperationException, MetadataException, IOException {
        String mdPath = request.getRequestPath();
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/"));
        mdPath = mdPath.substring(0, mdPath.lastIndexOf("/")) + "/maven-metadata.xml";
        RepositoryItemUid uid = request.getMavenRepository().createUid(mdPath);
        this.writeMetadata(uid, request.getRequestContext(), md);
    }
}

