/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.mime.NexusMimeTypes;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.MUtils;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.validator.AbstractMimeMagicFileTypeValidator;
import org.sonatype.nexus.proxy.repository.validator.FileTypeValidator;
import org.sonatype.nexus.proxy.repository.validator.XMLUtils;
import org.sonatype.nexus.util.SystemPropertiesHelper;

@Named(value="maven")
@Singleton
public class MavenFileTypeValidator
extends AbstractMimeMagicFileTypeValidator {
    public static final String XML_DETECTION_LAX_KEY = MavenFileTypeValidator.class.getName() + ".relaxedXmlValidation";
    private static final boolean XML_DETECTION_LAX = SystemPropertiesHelper.getBoolean(XML_DETECTION_LAX_KEY, true);
    private static final Pattern SITE_XML_FILENAME_PATTERN = Pattern.compile("^(.*)-site(_([a-z][a-z])(_([a-z][a-z]))?)?.xml$");

    @Inject
    public MavenFileTypeValidator(MimeSupport mimeSupport) {
        super(mimeSupport);
    }

    @VisibleForTesting
    public MavenFileTypeValidator(NexusMimeTypes mimeTypes, MimeSupport mimeSupport) {
        super(mimeTypes, mimeSupport);
    }

    @Override
    public FileTypeValidator.FileTypeValidity isExpectedFileType(StorageFileItem file) {
        MavenRepository mavenRepository = file.getRepositoryItemUid().getRepository().adaptToFacet(MavenRepository.class);
        if (mavenRepository == null) {
            return FileTypeValidator.FileTypeValidity.NEUTRAL;
        }
        String filePath = file.getPath().toLowerCase();
        if (filePath.endsWith(".pom")) {
            this.log.debug("Checking if Maven POM {} is of the correct MIME type.", (Object)file.getRepositoryItemUid());
            try {
                return XMLUtils.validateXmlLikeFile(file, "<project");
            }
            catch (IOException e) {
                this.log.warn("Cannot access content of StorageFileItem: {}", (Object)file.getRepositoryItemUid(), (Object)e);
                return FileTypeValidator.FileTypeValidity.NEUTRAL;
            }
        }
        if (SITE_XML_FILENAME_PATTERN.matcher(filePath).matches()) {
            this.log.debug("Checking if Maven Site Descriptor {} is of the correct MIME type.", (Object)file.getRepositoryItemUid());
            try {
                return XMLUtils.validateXmlLikeFile(file, "<project");
            }
            catch (IOException e) {
                this.log.warn("Cannot access content of StorageFileItem: {}", (Object)file.getRepositoryItemUid(), (Object)e);
                return FileTypeValidator.FileTypeValidity.NEUTRAL;
            }
        }
        if (filePath.endsWith("/maven-metadata.xml")) {
            this.log.debug("Checking if Maven Repository Metadata {} is of the correct MIME type.", (Object)file.getRepositoryItemUid());
            try {
                return XMLUtils.validateXmlLikeFile(file, "<metadata");
            }
            catch (IOException e) {
                this.log.warn("Cannot access content of StorageFileItem: {}", (Object)file.getRepositoryItemUid(), (Object)e);
                return FileTypeValidator.FileTypeValidity.NEUTRAL;
            }
        }
        if (filePath.endsWith(".sha1") || filePath.endsWith(".md5")) {
            this.log.debug("Checking if Maven Repository Metadata Hash {} is of the correct MIME type.", (Object)file.getRepositoryItemUid());
            try {
                String digest = MUtils.readDigestFromFileItem(file);
                if (MUtils.isDigest(digest)) {
                    if (filePath.endsWith(".sha1") && digest.length() == 40) {
                        return FileTypeValidator.FileTypeValidity.VALID;
                    }
                    if (filePath.endsWith(".md5") && digest.length() == 32) {
                        return FileTypeValidator.FileTypeValidity.VALID;
                    }
                }
                return FileTypeValidator.FileTypeValidity.INVALID;
            }
            catch (IOException e) {
                this.log.warn("Cannot access content of StorageFileItem: {}", (Object)file.getRepositoryItemUid(), (Object)e);
                return FileTypeValidator.FileTypeValidity.NEUTRAL;
            }
        }
        return super.isExpectedFileType(file);
    }

    @Override
    protected boolean isXmlLaxValidation(StorageFileItem file) {
        if (SystemPropertiesHelper.getString(XML_DETECTION_LAX_KEY, null) == null && !file.getItemContext().containsKey(XML_DETECTION_LAX_KEY)) {
            return super.isXmlLaxValidation(file);
        }
        boolean xmlLaxValidation = XML_DETECTION_LAX;
        if (file.getItemContext().containsKey(XML_DETECTION_LAX_KEY)) {
            xmlLaxValidation = Boolean.parseBoolean(String.valueOf(file.getItemContext().get(XML_DETECTION_LAX_KEY)));
        }
        return xmlLaxValidation;
    }
}

