/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.item.StorageFileItem;

public class MUtils {
    public static String readDigestFromStream(InputStream inputStream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(inputStream, Charsets.UTF_8);){
            String string = MUtils.readDigest(CharStreams.toString((Readable)isr));
            return string;
        }
    }

    @VisibleForTesting
    static String readDigest(String input) {
        String raw = StringUtils.chomp((String)input).trim();
        if (StringUtils.isEmpty((String)raw)) {
            return "";
        }
        String digest = raw.contains("=") || raw.contains(":") ? raw.split("[=:]", 2)[1].trim() : raw.split(" ", 2)[0];
        if (!MUtils.isDigest(digest)) {
            digest = MUtils.compress(digest);
        }
        if (!MUtils.isDigest(digest)) {
            digest = MUtils.compress(raw);
        }
        if (!MUtils.isDigest(digest) && raw.contains(" ")) {
            digest = MUtils.compress(raw.substring(0, raw.lastIndexOf(" ")).trim());
        }
        if (!MUtils.isDigest(digest)) {
            digest = raw.split(" ", 2)[0];
        }
        return digest;
    }

    private static String compress(String digest) {
        digest = digest.replaceAll(" ", "").toLowerCase(Locale.US);
        return digest;
    }

    public static boolean isDigest(String digest) {
        return digest.length() >= 32 && digest.matches("^[a-z0-9]+$");
    }

    public static String readDigestFromFileItem(StorageFileItem inputFileItem) throws IOException {
        return MUtils.readDigestFromStream(inputFileItem.getInputStream());
    }
}

