/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.DefaultStorageLinkItem;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.ArtifactStoreHelper;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MavenShadowRepository;
import org.sonatype.nexus.proxy.maven.MetadataManager;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.gav.GavCalculator;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;
import org.sonatype.nexus.proxy.repository.AbstractShadowRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.IncompatibleMasterRepositoryException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

public abstract class LayoutConverterShadowRepository
extends AbstractShadowRepository
implements MavenShadowRepository {
    private GavCalculator m1GavCalculator;
    private GavCalculator m2GavCalculator;
    private MetadataManager metadataManager;
    private ArtifactPackagingMapper artifactPackagingMapper;
    private RepositoryKind repositoryKind;
    private ArtifactStoreHelper artifactStoreHelper;

    @Inject
    public void populateLayoutConverterShadowRepository(@Named(value="maven1") GavCalculator m1GavCalculator, @Named(value="maven2") GavCalculator m2GavCalculator, MetadataManager metadataManager, ArtifactPackagingMapper artifactPackagingMapper) {
        this.m1GavCalculator = (GavCalculator)Preconditions.checkNotNull((Object)m1GavCalculator);
        this.m2GavCalculator = (GavCalculator)Preconditions.checkNotNull((Object)m2GavCalculator);
        this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager);
        this.artifactPackagingMapper = (ArtifactPackagingMapper)Preconditions.checkNotNull((Object)artifactPackagingMapper);
        this.repositoryKind = new DefaultRepositoryKind(MavenShadowRepository.class, Arrays.asList(MavenRepository.class));
        this.artifactStoreHelper = new ArtifactStoreHelper(this);
    }

    @Override
    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    @Override
    public MavenRepository getMasterRepository() {
        return super.getMasterRepository().adaptToFacet(MavenRepository.class);
    }

    @Override
    public void setMasterRepository(Repository masterRepository) throws IncompatibleMasterRepositoryException {
        if (!masterRepository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
            throw new IncompatibleMasterRepositoryException("This shadow repository needs master repository which implements MavenRepository interface!", this, masterRepository.getId());
        }
        super.setMasterRepository(masterRepository);
    }

    public GavCalculator getM1GavCalculator() {
        return this.m1GavCalculator;
    }

    public GavCalculator getM2GavCalculator() {
        return this.m2GavCalculator;
    }

    @Override
    public ArtifactPackagingMapper getArtifactPackagingMapper() {
        return this.artifactPackagingMapper;
    }

    @Override
    public RepositoryPolicy getRepositoryPolicy() {
        return this.getMasterRepository().getRepositoryPolicy();
    }

    @Override
    public void setRepositoryPolicy(RepositoryPolicy repositoryPolicy) {
        throw new UnsupportedOperationException("This method is not supported on Repository of type SHADOW");
    }

    @Override
    public boolean isMavenArtifact(StorageItem item) {
        return this.isMavenArtifactPath(item.getPath());
    }

    @Override
    public boolean isMavenMetadata(StorageItem item) {
        return this.isMavenMetadataPath(item.getPath());
    }

    @Override
    public boolean isMavenArtifactPath(String path) {
        return this.getGavCalculator().pathToGav(path) != null;
    }

    @Override
    public abstract boolean isMavenMetadataPath(String var1);

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public boolean recreateMavenMetadata(ResourceStoreRequest request) {
        return false;
    }

    @Override
    public void storeItemWithChecksums(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        String originalPath = request.getRequestPath();
        if (this.log.isDebugEnabled()) {
            this.log.debug("storeItemWithChecksums() :: " + request.getRequestPath());
        }
        try {
            try {
                this.storeItem(request, is, userAttributes);
            }
            catch (IOException e) {
                throw new LocalStorageException("Could not get the content from the ContentLocator!", e);
            }
            StorageFileItem storedFile = (StorageFileItem)this.retrieveItem(false, request);
            String sha1Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
            String md5Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY);
            if (!StringUtils.isEmpty((String)sha1Hash)) {
                request.setRequestPath(storedFile.getPath() + ".sha1");
                this.storeItem(false, new DefaultStorageFileItem(this, request, true, true, (ContentLocator)new StringContentLocator(sha1Hash)));
            }
            if (!StringUtils.isEmpty((String)md5Hash)) {
                request.setRequestPath(storedFile.getPath() + ".md5");
                this.storeItem(false, new DefaultStorageFileItem(this, request, true, true, (ContentLocator)new StringContentLocator(md5Hash)));
            }
        }
        catch (ItemNotFoundException e) {
            throw new LocalStorageException("Storage inconsistency!", e);
        }
        finally {
            request.setRequestPath(originalPath);
        }
    }

    @Override
    public void deleteItemWithChecksums(ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        block8: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("deleteItemWithChecksums() :: " + request.getRequestPath());
            }
            try {
                this.deleteItem(request);
            }
            catch (ItemNotFoundException e) {
                if (request.getRequestPath().endsWith(".asc")) break block8;
                throw e;
            }
        }
        String originalPath = request.getRequestPath();
        request.setRequestPath(originalPath + ".sha1");
        try {
            this.deleteItem(request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        request.setRequestPath(originalPath + ".md5");
        try {
            this.deleteItem(request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (!originalPath.endsWith(".asc")) {
            request.setRequestPath(originalPath + ".asc");
            this.deleteItemWithChecksums(request);
        }
    }

    @Override
    public void storeItemWithChecksums(boolean fromTask, AbstractStorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("storeItemWithChecksums() :: " + item.getRepositoryItemUid().toString());
        }
        try {
            try {
                this.storeItem(fromTask, item);
            }
            catch (IOException e) {
                throw new LocalStorageException("Could not get the content from the ContentLocator!", e);
            }
            StorageFileItem storedFile = (StorageFileItem)this.retrieveItem(fromTask, new ResourceStoreRequest(item));
            ResourceStoreRequest req = new ResourceStoreRequest(storedFile);
            String sha1Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
            String md5Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY);
            if (!StringUtils.isEmpty((String)sha1Hash)) {
                req.setRequestPath(item.getPath() + ".sha1");
                this.storeItem(fromTask, new DefaultStorageFileItem(this, req, true, true, (ContentLocator)new StringContentLocator(sha1Hash)));
            }
            if (!StringUtils.isEmpty((String)md5Hash)) {
                req.setRequestPath(item.getPath() + ".md5");
                this.storeItem(fromTask, new DefaultStorageFileItem(this, req, true, true, (ContentLocator)new StringContentLocator(md5Hash)));
            }
        }
        catch (ItemNotFoundException e) {
            throw new LocalStorageException("Storage inconsistency!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItemWithChecksums(boolean fromTask, ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("deleteItemWithChecksums() :: " + request.toString());
        }
        this.deleteItem(fromTask, request);
        request.pushRequestPath(request.getRequestPath() + ".sha1");
        try {
            this.deleteItem(fromTask, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        finally {
            request.popRequestPath();
        }
        request.pushRequestPath(request.getRequestPath() + ".md5");
        try {
            this.deleteItem(fromTask, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        finally {
            request.popRequestPath();
        }
    }

    @Override
    public ArtifactStoreHelper getArtifactStoreHelper() {
        return this.artifactStoreHelper;
    }

    protected List<String> transformM1toM2(String path) {
        Gav gav = this.getM1GavCalculator().pathToGav(path);
        if (gav == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("/");
        sb.append(gav.getGroupId().replaceAll("\\.", "/"));
        sb.append("/");
        sb.append(gav.getArtifactId());
        sb.append("/");
        sb.append(gav.getVersion());
        sb.append("/");
        sb.append(gav.getName());
        return Collections.singletonList(sb.toString());
    }

    protected List<String> transformM2toM1(String path, List<String> extraFolders) {
        Gav gav = this.getM2GavCalculator().pathToGav(path);
        if (gav == null) {
            return null;
        }
        ArrayList exts = Lists.newArrayList();
        exts.add(gav.getExtension() + "s");
        if (extraFolders != null && !extraFolders.isEmpty()) {
            exts.addAll(extraFolders);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)exts.size());
        for (String ext : exts) {
            StringBuilder sb = new StringBuilder("/");
            sb.append(gav.getGroupId());
            sb.append("/");
            sb.append(ext);
            sb.append("/");
            if (gav.isSnapshot()) {
                sb.append(gav.getArtifactId()).append("-").append(gav.getBaseVersion());
                if (!StringUtils.isEmpty((String)gav.getClassifier())) {
                    sb.append("-").append(gav.getClassifier());
                }
                sb.append(".").append(gav.getExtension());
                if (gav.isHash()) {
                    sb.append(".").append((Object)gav.getHashType());
                }
                if (gav.isSignature()) {
                    sb.append(".").append((Object)gav.getSignatureType());
                }
            } else {
                sb.append(gav.getName());
            }
            result.add(sb.toString());
        }
        return result;
    }

    @Override
    protected StorageLinkItem createLink(StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        List<String> shadowPaths = this.transformMaster2Shadow(item.getPath());
        if (shadowPaths != null && !shadowPaths.isEmpty()) {
            ResourceStoreRequest req = new ResourceStoreRequest(shadowPaths.get(0));
            req.getRequestContext().setParentContext(item.getItemContext());
            DefaultStorageLinkItem link = new DefaultStorageLinkItem(this, req, true, true, item.getRepositoryItemUid());
            this.storeItem(false, link);
            return link;
        }
        return null;
    }

    @Override
    protected void deleteLink(StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        List<String> shadowPaths = this.transformMaster2Shadow(item.getPath());
        if (shadowPaths != null && !shadowPaths.isEmpty()) {
            ResourceStoreRequest req = new ResourceStoreRequest(shadowPaths.get(0));
            req.getRequestContext().setParentContext(item.getItemContext());
            try {
                this.deleteItem(false, req);
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
            String parentPath = req.getRequestPath().substring(0, req.getRequestPath().lastIndexOf(item.getName()));
            ResourceStoreRequest parentRequest = new ResourceStoreRequest(parentPath);
            while (parentRequest != null) {
                StorageItem parentItem = null;
                parentItem = this.retrieveItem(false, parentRequest);
                if (StorageCollectionItem.class.isInstance(parentItem)) {
                    StorageCollectionItem parentCollectionItem = (StorageCollectionItem)parentItem;
                    try {
                        if (parentCollectionItem.list().size() == 0) {
                            this.deleteItem(false, parentRequest);
                            parentRequest = new ResourceStoreRequest(parentCollectionItem.getParentPath());
                            continue;
                        }
                        parentRequest = null;
                    }
                    catch (AccessDeniedException e) {
                        this.log.debug("Failed to delete shadow parent: " + this.getId() + ":" + parentItem.getPath() + " Access Denied", (Throwable)e);
                        parentRequest = null;
                    }
                    catch (NoSuchResourceStoreException e) {
                        this.log.debug("Failed to delete shadow parent: " + this.getId() + ":" + parentItem.getPath() + " does not exist", (Throwable)e);
                        parentRequest = null;
                    }
                    continue;
                }
                this.log.debug("ExpectedCollectionItem, found: " + parentItem.getClass() + ", ignoring.");
            }
        }
    }

    protected abstract List<String> transformMaster2Shadow(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        StorageItem result = null;
        try {
            return super.doRetrieveItem(request);
        }
        catch (ItemNotFoundException e) {
            List<String> transformedPaths = this.transformShadow2Master(request.getRequestPath());
            if (transformedPaths == null || transformedPaths.isEmpty()) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Request path %s is not transformable to master.", request.getRequestPath()));
            }
            Iterator<String> iterator = transformedPaths.iterator();
            while (iterator.hasNext()) {
                String transformedPath = iterator.next();
                request.pushRequestPath(transformedPath);
                try {
                    result = this.doRetrieveItemFromMaster(request);
                    try {
                        StorageLinkItem link = this.createLink(result);
                        if (link == null) return result;
                        StorageLinkItem storageLinkItem = link;
                        request.popRequestPath();
                        return storageLinkItem;
                    }
                    catch (Exception e1) {
                        return result;
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
            }
            throw new ItemNotFoundException(request, this);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    protected abstract List<String> transformShadow2Master(String var1);
}

