/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.EvictUnusedItemsWalkerProcessor;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;

public class EvictUnusedMavenItemsWalkerProcessor
extends EvictUnusedItemsWalkerProcessor {
    public EvictUnusedMavenItemsWalkerProcessor(long timestamp) {
        super(timestamp);
    }

    @Override
    public void doDelete(WalkerContext ctx, StorageFileItem item) throws StorageException, UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException {
        MavenRepository repository = (MavenRepository)this.getRepository(ctx);
        ResourceStoreRequest rsr = new ResourceStoreRequest(item);
        rsr.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)DeleteOperation.DELETE_PERMANENTLY);
        repository.deleteItemWithChecksums(false, rsr);
    }

    @Override
    public void onCollectionExit(WalkerContext ctx, StorageCollectionItem coll) {
        try {
            if (this.getRepository(ctx).list(false, coll).size() == 0) {
                ResourceStoreRequest rsr = new ResourceStoreRequest(coll);
                rsr.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)DeleteOperation.DELETE_PERMANENTLY);
                ((MavenRepository)this.getRepository(ctx)).deleteItemWithChecksums(false, rsr);
            }
        }
        catch (UnsupportedStorageOperationException e) {
            ctx.stop(e);
        }
        catch (ItemNotFoundException e) {
        }
        catch (IllegalOperationException e) {
            ctx.stop(e);
        }
        catch (StorageException e) {
            ctx.stop(e);
        }
    }

    public static class EvictUnusedMavenItemsWalkerFilter
    extends EvictUnusedItemsWalkerProcessor.EvictUnusedItemsWalkerFilter {
        @Override
        public boolean shouldProcess(WalkerContext context, StorageItem item) {
            return super.shouldProcess(context, item) && !item.getPath().startsWith("/.index") && !item.getPath().endsWith(".asc") && !item.getPath().endsWith(".sha1") && !item.getPath().endsWith(".md5");
        }
    }
}

