/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MetadataLocator;
import org.sonatype.nexus.proxy.maven.MetadataUpdater;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddPluginOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.AddVersionOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataBuilder;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataException;
import org.sonatype.nexus.proxy.maven.metadata.operations.MetadataOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.nexus.proxy.maven.metadata.operations.PluginOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.SetSnapshotOperation;
import org.sonatype.nexus.proxy.maven.metadata.operations.SnapshotOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.StringOperand;
import org.sonatype.nexus.proxy.maven.metadata.operations.TimeUtil;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultMetadataUpdater
extends ComponentSupport
implements MetadataUpdater {
    private final MetadataLocator locator;

    @Inject
    public DefaultMetadataUpdater(MetadataLocator locator) {
        this.locator = locator;
    }

    @Override
    public void deployArtifact(ArtifactStoreRequest request) throws IOException {
        if (!this.doesImpactMavenMetadata(request.getGav())) {
            return;
        }
        try {
            ArrayList<MetadataOperation> operations = null;
            Gav gav = this.locator.getGavForRequest(request);
            Metadata gavMd = this.locator.retrieveGAVMetadata(request);
            operations = new ArrayList<MetadataOperation>();
            gavMd.setGroupId(gav.getGroupId());
            gavMd.setArtifactId(gav.getArtifactId());
            gavMd.setVersion(gav.getBaseVersion());
            if (gav.isSnapshot()) {
                operations.add(new SetSnapshotOperation(new SnapshotOperand(ModelVersionUtility.getModelVersion(gavMd), TimeUtil.getUTCTimestamp(), MetadataBuilder.createSnapshot(request.getVersion()), this.buildVersioning(gav))));
                MetadataBuilder.changeMetadata(gavMd, operations);
                this.locator.storeGAVMetadata(request, gavMd);
            }
            operations = new ArrayList();
            Metadata gaMd = this.locator.retrieveGAMetadata(request);
            operations.add(new AddVersionOperation(new StringOperand(ModelVersionUtility.getModelVersion(gaMd), gav.getBaseVersion())));
            MetadataBuilder.changeMetadata(gaMd, operations);
            this.locator.storeGAMetadata(request, gaMd);
            operations = new ArrayList();
            if (StringUtils.equals((String)"maven-plugin", (String)this.locator.retrievePackagingFromPom(request))) {
                Metadata gMd = this.locator.retrieveGMetadata(request);
                Plugin pluginElem = this.locator.extractPluginElementFromPom(request);
                if (pluginElem != null) {
                    operations.add(new AddPluginOperation(new PluginOperand(ModelVersionUtility.getModelVersion(gMd), pluginElem)));
                    MetadataBuilder.changeMetadata(gMd, operations);
                    this.locator.storeGMetadata(request, gMd);
                }
            }
        }
        catch (MetadataException e) {
            throw new LocalStorageException("Not able to apply changes!", e);
        }
    }

    @VisibleForTesting
    boolean doesImpactMavenMetadata(Gav requestGav) {
        return !requestGav.isHash() && !requestGav.isSignature() && (!StringUtils.isNotBlank((String)requestGav.getClassifier()) || requestGav.isSnapshot());
    }

    private SnapshotVersion buildVersioning(Gav gav) {
        SnapshotVersion version = new SnapshotVersion();
        version.setClassifier(gav.getClassifier());
        version.setExtension(gav.getExtension());
        version.setVersion(gav.getVersion());
        version.setUpdated(TimeUtil.getUTCTimestamp());
        return version;
    }
}

