/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MetadataLocator;
import org.sonatype.nexus.proxy.maven.MetadataManager;
import org.sonatype.nexus.proxy.maven.MetadataUpdater;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.maven.metadata.operations.ModelVersionUtility;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Singleton
@Named
public class DefaultMetadataManager
extends ComponentSupport
implements MetadataManager {
    static final String LATEST_VERSION = "LATEST";
    static final String SNAPSHOT_VERSION = "SNAPSHOT";
    static final String RELEASE_VERSION = "RELEASE";
    private final MetadataUpdater metadataUpdater;
    private final MetadataLocator metadataLocator;
    private static final String METADATA_TIMESTAMP_FORMAT_MAVEN2 = "yyyyMMdd.HHmmss";
    private static final String METADATA_TIMESTAMP_FORMAT_MAVEN3_UPDATED = "yyyyMMddHHmmss";

    @Inject
    public DefaultMetadataManager(MetadataUpdater metadataUpdater, MetadataLocator metadataLocator) {
        this.metadataUpdater = (MetadataUpdater)Preconditions.checkNotNull((Object)metadataUpdater);
        this.metadataLocator = (MetadataLocator)Preconditions.checkNotNull((Object)metadataLocator);
    }

    @Override
    public void deployArtifact(ArtifactStoreRequest request) throws IOException {
        this.metadataUpdater.deployArtifact(request);
    }

    @Override
    public Gav resolveArtifact(ArtifactStoreRequest gavRequest) throws IOException {
        MavenRepository repository = gavRequest.getMavenRepository();
        String version = gavRequest.getVersion();
        Gav gav = null;
        if (LATEST_VERSION.equals(gavRequest.getVersion())) {
            gav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), RepositoryPolicy.SNAPSHOT.equals((Object)repository.getRepositoryPolicy()) ? "1-SNAPSHOT" : "1", gavRequest.getClassifier(), gavRequest.getExtension(), null, null, null, false, null, false, null);
            version = this.resolveLatest(gavRequest, gav);
        } else if (RELEASE_VERSION.equals(gavRequest.getVersion())) {
            gav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), RepositoryPolicy.SNAPSHOT.equals((Object)repository.getRepositoryPolicy()) ? "1-SNAPSHOT" : "1", gavRequest.getClassifier(), gavRequest.getExtension(), null, null, null, false, null, false, null);
            version = this.resolveRelease(gavRequest, gav);
        }
        if (LATEST_VERSION.equals(version) || RELEASE_VERSION.equals(version)) {
            return null;
        }
        gav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), version, gavRequest.getClassifier(), gavRequest.getExtension(), null, null, null, false, null, false, null);
        if (gav.isSnapshot() && gav.getVersion().equals(gav.getBaseVersion())) {
            gav = this.resolveSnapshot(gavRequest, gav);
        }
        return gav;
    }

    protected String resolveLatest(ArtifactStoreRequest gavRequest, Gav gav) throws IOException {
        String latest;
        MavenRepository repository = gavRequest.getMavenRepository();
        Metadata gaMd = this.metadataLocator.retrieveGAMetadata(new ArtifactStoreRequest(gavRequest.getMavenRepository(), gav, gavRequest.isRequestLocalOnly(), gavRequest.isRequestRemoteOnly()));
        if (gaMd.getVersioning() == null) {
            gaMd.setVersioning(new Versioning());
        }
        if (StringUtils.isEmpty((String)(latest = gaMd.getVersioning().getLatest())) && gaMd.getVersioning().getVersions() != null) {
            List versions = gaMd.getVersioning().getVersions();
            for (int i = versions.size() - 1; i >= 0; --i) {
                if (RepositoryPolicy.RELEASE.equals((Object)repository.getRepositoryPolicy())) {
                    if (Gav.isSnapshot((String)versions.get(i))) continue;
                    latest = (String)versions.get(i);
                    break;
                }
                if (RepositoryPolicy.SNAPSHOT.equals((Object)repository.getRepositoryPolicy())) {
                    if (!Gav.isSnapshot((String)versions.get(i))) continue;
                    latest = (String)versions.get(i);
                    break;
                }
                latest = (String)versions.get(i);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)latest)) {
            return latest;
        }
        return gavRequest.getVersion();
    }

    protected String resolveRelease(ArtifactStoreRequest gavRequest, Gav gav) throws IOException {
        String release;
        Metadata gaMd;
        MavenRepository repository = gavRequest.getMavenRepository();
        if (RepositoryPolicy.SNAPSHOT.equals((Object)repository.getRepositoryPolicy())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not a RELEASE repository for resolving GAV: " + gav.getGroupId() + " : " + gav.getArtifactId() + " : " + gav.getVersion() + " in repository " + repository.getId());
            }
            return gavRequest.getVersion();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolving snapshot version for GAV: " + gavRequest.getGroupId() + " : " + gavRequest.getArtifactId() + " : " + gavRequest.getVersion() + " in repository " + repository.getId());
        }
        if ((gaMd = this.metadataLocator.retrieveGAMetadata(new ArtifactStoreRequest(gavRequest.getMavenRepository(), gav, gavRequest.isRequestLocalOnly(), gavRequest.isRequestRemoteOnly()))).getVersioning() == null) {
            gaMd.setVersioning(new Versioning());
        }
        if (StringUtils.isEmpty((String)(release = gaMd.getVersioning().getRelease())) && gaMd.getVersioning().getVersions() != null) {
            List versions = gaMd.getVersioning().getVersions();
            for (int i = versions.size() - 1; i >= 0; --i) {
                if (Gav.isSnapshot((String)versions.get(i))) continue;
                release = (String)versions.get(i);
                break;
            }
        }
        if (!StringUtils.isEmpty((String)release)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved gav version from '" + gav.getVersion() + "' to '" + release + "'");
            }
            return release;
        }
        return gavRequest.getVersion();
    }

    @Override
    public Gav resolveSnapshot(ArtifactStoreRequest gavRequest, Gav gav) throws IOException {
        Metadata gavMd;
        MavenRepository repository = gavRequest.getMavenRepository();
        if (gav.isSnapshot() && !gav.getVersion().equals(gav.getBaseVersion())) {
            return gav;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolving snapshot version for GAV: " + gav.getGroupId() + " : " + gav.getArtifactId() + " : " + gav.getVersion() + " in repository " + repository.getId());
        }
        if ((gavMd = this.metadataLocator.retrieveGAVMetadata(new ArtifactStoreRequest(gavRequest.getMavenRepository(), gav, gavRequest.isRequestLocalOnly(), gavRequest.isRequestRemoteOnly()))).getVersioning() == null) {
            gavMd.setVersioning(new Versioning());
        }
        if (ModelVersionUtility.Version.V110.compareTo(ModelVersionUtility.getModelVersion(gavMd)) <= 0) {
            return this.resolveSnapshotFromM3Metadata(gavRequest, gav, gavMd);
        }
        return this.resolveSnapshotFromM2Metadata(gavRequest, gav, gavMd);
    }

    protected Gav resolveSnapshotFromM2Metadata(ArtifactStoreRequest gavRequest, Gav gav, Metadata gavMd) throws IOException {
        String latest = null;
        Long buildTs = null;
        Integer buildNo = null;
        Snapshot current = gavMd.getVersioning().getSnapshot();
        if (current != null && StringUtils.isNotBlank((String)current.getTimestamp()) && current.getBuildNumber() > 0) {
            latest = gav.getBaseVersion();
            latest = latest.replace(SNAPSHOT_VERSION, current.getTimestamp() + "-" + current.getBuildNumber());
            buildTs = DefaultMetadataManager.getTimeFromMetadataTimestampMaven2(current.getTimestamp());
            buildNo = current.getBuildNumber();
        }
        if (!StringUtils.isEmpty(latest) && Gav.isSnapshot(latest)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved gav version from '" + gav.getVersion() + "' to '" + latest + "'");
            }
            Gav result = new Gav(gav.getGroupId(), gav.getArtifactId(), latest, gav.getClassifier(), gav.getExtension(), buildNo, buildTs, gav.getName(), gav.isHash(), gav.getHashType(), gav.isSignature(), gav.getSignatureType());
            return result;
        }
        return gav;
    }

    protected Gav resolveSnapshotFromM3Metadata(ArtifactStoreRequest gavRequest, Gav gav, Metadata gavMd) throws IOException {
        for (SnapshotVersion sv : gavMd.getVersioning().getSnapshotVersions()) {
            if (!StringUtils.equals((String)sv.getExtension(), (String)gav.getExtension()) || !StringUtils.equals((String)StringUtils.defaultString((Object)sv.getClassifier(), (String)""), (String)StringUtils.defaultString((Object)gav.getClassifier(), (String)""))) continue;
            Long buildTs = DefaultMetadataManager.getTimeFromMetadataTimestampMaven3Updated(sv.getUpdated());
            Integer buildNo = DefaultMetadataManager.getBuildNumberForMetadataMaven3Value(sv.getVersion());
            return new Gav(gav.getGroupId(), gav.getArtifactId(), sv.getVersion(), gav.getClassifier(), gav.getExtension(), buildNo, buildTs, gav.getName(), gav.isHash(), gav.getHashType(), gav.isSignature(), gav.getSignatureType());
        }
        return this.resolveSnapshotFromM2Metadata(gavRequest, gav, gavMd);
    }

    private static Long getTimeFromMetadataTimestamp(String dateFormat, String tsString) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
            return df.parse(tsString).getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected static Long getTimeFromMetadataTimestampMaven3Updated(String tsString) {
        return DefaultMetadataManager.getTimeFromMetadataTimestamp(METADATA_TIMESTAMP_FORMAT_MAVEN3_UPDATED, tsString);
    }

    protected static Long getTimeFromMetadataTimestampMaven2(String tsString) {
        return DefaultMetadataManager.getTimeFromMetadataTimestamp(METADATA_TIMESTAMP_FORMAT_MAVEN2, tsString);
    }

    protected static Integer getBuildNumberForMetadataMaven3Value(String valueString) {
        try {
            int lastIdx = valueString.lastIndexOf(45);
            if (lastIdx > -1) {
                return Integer.valueOf(valueString.substring(lastIdx + 1));
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

