/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.RemoteAccessException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.AbstractChecksumContentValidator;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.MUtils;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.RemoteHashResponse;
import org.sonatype.nexus.proxy.repository.ItemContentValidator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

@Named(value="ChecksumContentValidator")
@Singleton
public class ChecksumContentValidator
extends AbstractChecksumContentValidator
implements ItemContentValidator {
    public static final String ID = "ChecksumContentValidator";
    public static final String SUFFIX_MD5 = ".md5";
    public static final String SUFFIX_SHA1 = ".sha1";
    public static final String ATTR_REMOTE_SHA1 = "remote.sha1";
    public static final String ATTR_REMOTE_MD5 = "remote.md5";
    public static final String ATTR_REMOTE_HASH_EXPIRED = "remote.hash.expired";

    @Override
    protected void cleanup(ProxyRepository proxy, RemoteHashResponse remoteHash, boolean contentValid) throws LocalStorageException {
        if (!contentValid && remoteHash != null && remoteHash.getHashItem() != null) {
            try {
                String path = remoteHash.getHashItem().getRepositoryItemUid().getPath();
                proxy.getLocalStorage().deleteItem(proxy, new ResourceStoreRequest(path, true));
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    protected ChecksumPolicy getChecksumPolicy(ProxyRepository proxy, AbstractStorageItem item) {
        if (this.isChecksum(item.getRepositoryItemUid().getPath())) {
            return null;
        }
        if (!proxy.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class)) {
            return null;
        }
        MavenProxyRepository mpr = proxy.adaptToFacet(MavenProxyRepository.class);
        ChecksumPolicy checksumPolicy = mpr.getChecksumPolicy();
        if (checksumPolicy == null || !checksumPolicy.shouldCheckChecksum() || !(item instanceof DefaultStorageFileItem)) {
            return null;
        }
        return checksumPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RemoteHashResponse retrieveRemoteHash(AbstractStorageItem item, ProxyRepository proxy, String baseUrl) throws LocalStorageException {
        RepositoryItemUid uid = item.getRepositoryItemUid();
        ResourceStoreRequest request = new ResourceStoreRequest(item);
        RemoteHashResponse response = null;
        try {
            request.pushRequestPath(uid.getPath() + SUFFIX_SHA1);
            try {
                response = ChecksumContentValidator.doRetrieveSHA1(proxy, request, item);
            }
            finally {
                request.popRequestPath();
            }
        }
        catch (ItemNotFoundException e) {
            request.pushRequestPath(uid.getPath() + SUFFIX_MD5);
            try {
                response = ChecksumContentValidator.doRetrieveMD5(proxy, request, item);
            }
            catch (ItemNotFoundException e1) {
                this.log.debug("Item checksums (SHA1, MD5) remotely unavailable " + uid.toString());
            }
            finally {
                request.popRequestPath();
            }
        }
        return response;
    }

    private boolean isChecksum(String path) {
        return path.endsWith(SUFFIX_SHA1) || path.endsWith(SUFFIX_MD5);
    }

    public static RemoteHashResponse doRetrieveSHA1(ProxyRepository proxy, ResourceStoreRequest hashRequest, StorageItem artifact) throws LocalStorageException, ItemNotFoundException {
        return ChecksumContentValidator.doRetrieveChecksumItem(proxy, hashRequest, artifact, DigestCalculatingInspector.DIGEST_SHA1_KEY, ATTR_REMOTE_SHA1);
    }

    public static RemoteHashResponse doRetrieveMD5(ProxyRepository proxy, ResourceStoreRequest hashRequest, StorageItem artifact) throws LocalStorageException, ItemNotFoundException {
        return ChecksumContentValidator.doRetrieveChecksumItem(proxy, hashRequest, artifact, DigestCalculatingInspector.DIGEST_MD5_KEY, ATTR_REMOTE_MD5);
    }

    private static RemoteHashResponse doRetrieveChecksumItem(ProxyRepository proxy, ResourceStoreRequest request, StorageItem artifact, String inspector, String attrname) throws ItemNotFoundException, LocalStorageException {
        RepositoryItemUid itemUid = artifact.getRepositoryItemUid();
        itemUid.getLock().lock(Action.read);
        try {
            Attributes attributes = artifact.getRepositoryItemAttributes();
            if (attributes == null) {
                throw new LocalStorageException("Null item repository attributes");
            }
            String hash = attributes.get(attrname);
            if (hash == null || request.isRequestAsExpired() || attributes.containsKey(ATTR_REMOTE_HASH_EXPIRED)) {
                try {
                    StorageFileItem remoteItem = (StorageFileItem)((Object)proxy.getRemoteStorage().retrieveItem(proxy, request, proxy.getRemoteUrl()));
                    hash = MUtils.readDigestFromFileItem(remoteItem);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (RemoteAccessException remoteAccessException) {
                }
                catch (RemoteStorageException remoteStorageException) {
                    // empty catch block
                }
                ChecksumContentValidator.doStoreChechsumItem(proxy, artifact, attrname, hash);
            }
            if (hash != null) {
                RemoteHashResponse remoteHashResponse = new RemoteHashResponse(inspector, hash, ChecksumContentValidator.newHashItem(proxy, request, artifact, hash));
                return remoteHashResponse;
            }
            try {
                throw new ItemNotFoundException(request);
            }
            catch (IOException e) {
                throw new LocalStorageException(e);
            }
        }
        finally {
            itemUid.getLock().unlock();
        }
    }

    public static void doStoreSHA1(ProxyRepository proxy, StorageItem artifact, StorageFileItem hash) throws LocalStorageException {
        try {
            ChecksumContentValidator.doStoreChechsumItem(proxy, artifact, ATTR_REMOTE_SHA1, MUtils.readDigestFromFileItem(hash));
        }
        catch (IOException e) {
            throw new LocalStorageException(e);
        }
    }

    public static void doStoreMD5(ProxyRepository proxy, StorageItem artifact, StorageFileItem hash) throws LocalStorageException {
        try {
            ChecksumContentValidator.doStoreChechsumItem(proxy, artifact, ATTR_REMOTE_MD5, MUtils.readDigestFromFileItem(hash));
        }
        catch (IOException e) {
            throw new LocalStorageException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doStoreChechsumItem(ProxyRepository proxy, StorageItem artifact, String attrname, String hash) throws IOException {
        if (hash != null) {
            RepositoryItemUid itemUid = artifact.getRepositoryItemUid();
            itemUid.getLock().lock(Action.update);
            Attributes attributes = artifact.getRepositoryItemAttributes();
            try {
                attributes.put(attrname, hash);
                attributes.remove(ATTR_REMOTE_HASH_EXPIRED);
                attributes.remove("remote.no-sha1");
                attributes.remove("remote.no-md5");
                proxy.getAttributesHandler().storeAttributes(artifact);
            }
            finally {
                itemUid.getLock().unlock();
            }
        }
    }

    public static DefaultStorageFileItem newHashItem(ProxyRepository proxy, ResourceStoreRequest request, StorageItem artifact, String hash) {
        StringContentLocator content = new StringContentLocator(hash);
        DefaultStorageFileItem hashItem = new DefaultStorageFileItem(proxy, request, true, false, (ContentLocator)content);
        hashItem.setModified(artifact.getModified());
        return hashItem;
    }
}

