/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class ArtifactStoreRequest
extends ResourceStoreRequest {
    private final MavenRepository mavenRepository;
    private final Gav gav;

    public ArtifactStoreRequest(MavenRepository repository, Gav gav, boolean localOnly) {
        this(repository, gav, localOnly, false);
    }

    public ArtifactStoreRequest(MavenRepository repository, Gav gav, boolean localOnly, boolean remoteOnly) {
        super(repository.getGavCalculator().gavToPath(gav), localOnly, remoteOnly);
        this.mavenRepository = repository;
        this.gav = gav;
    }

    public MavenRepository getMavenRepository() {
        return this.mavenRepository;
    }

    public Gav getGav() {
        return this.gav;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getClassifier() {
        return this.gav.getClassifier();
    }

    public String getExtension() {
        return this.gav.getExtension();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("(GAVCE=");
        sb.append(this.getGroupId());
        sb.append(":");
        sb.append(this.getArtifactId());
        sb.append(":");
        sb.append(this.getVersion());
        sb.append(":c=");
        sb.append(this.getClassifier());
        sb.append(":e=");
        sb.append(this.getExtension());
        sb.append(", for ");
        sb.append(RepositoryStringUtils.getHumanizedNameString(this.getMavenRepository()));
        sb.append(") ");
        return sb.toString();
    }
}

