/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class ArtifactStoreHelper {
    private final MavenRepository repository;

    protected ArtifactStoreHelper(MavenRepository repo) {
        this.repository = repo;
    }

    public MavenRepository getMavenRepository() {
        return this.repository;
    }

    public void storeItemWithChecksums(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        String originalPath = request.getRequestPath();
        try {
            try {
                this.getMavenRepository().storeItem(request, is, userAttributes);
            }
            catch (IOException e) {
                throw new LocalStorageException(String.format("Could not store item to repository %s, path %s", RepositoryStringUtils.getHumanizedNameString(this.getMavenRepository()), request), e);
            }
            StorageFileItem storedFile = (StorageFileItem)this.getMavenRepository().retrieveItem(false, new ResourceStoreRequest(request));
            String sha1Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
            String md5Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY);
            if (!StringUtils.isEmpty((String)sha1Hash)) {
                request.setRequestPath(storedFile.getPath() + ".sha1");
                this.getMavenRepository().storeItem(false, new DefaultStorageFileItem(this.getMavenRepository(), request, true, true, (ContentLocator)new StringContentLocator(sha1Hash)));
            }
            if (!StringUtils.isEmpty((String)md5Hash)) {
                request.setRequestPath(storedFile.getPath() + ".md5");
                this.getMavenRepository().storeItem(false, new DefaultStorageFileItem(this.getMavenRepository(), request, true, true, (ContentLocator)new StringContentLocator(md5Hash)));
            }
        }
        catch (ItemNotFoundException e) {
            throw new LocalStorageException("Storage inconsistency!", e);
        }
        finally {
            request.setRequestPath(originalPath);
        }
    }

    public void deleteItemWithChecksums(ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        block7: {
            try {
                this.getMavenRepository().deleteItem(request);
            }
            catch (ItemNotFoundException e) {
                if (request.getRequestPath().endsWith(".asc")) break block7;
                throw e;
            }
        }
        String originalPath = request.getRequestPath();
        request.setRequestPath(originalPath + ".sha1");
        try {
            this.getMavenRepository().deleteItem(request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        request.setRequestPath(originalPath + ".md5");
        try {
            this.getMavenRepository().deleteItem(request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (!originalPath.endsWith(".asc")) {
            request.setRequestPath(originalPath + ".asc");
            this.deleteItemWithChecksums(request);
        }
    }

    public void storeItemWithChecksums(boolean fromTask, AbstractStorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        try {
            try {
                this.getMavenRepository().storeItem(false, item);
            }
            catch (IOException e) {
                throw new LocalStorageException("Could not get the content from the ContentLocator!", e);
            }
            StorageFileItem storedFile = (StorageFileItem)this.getMavenRepository().retrieveItem(false, new ResourceStoreRequest(item));
            ResourceStoreRequest req = new ResourceStoreRequest(storedFile);
            String sha1Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY);
            String md5Hash = storedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_MD5_KEY);
            if (!StringUtils.isEmpty((String)sha1Hash)) {
                req.setRequestPath(item.getPath() + ".sha1");
                this.getMavenRepository().storeItem(false, new DefaultStorageFileItem(this.getMavenRepository(), req, true, true, (ContentLocator)new StringContentLocator(sha1Hash)));
            }
            if (!StringUtils.isEmpty((String)md5Hash)) {
                req.setRequestPath(item.getPath() + ".md5");
                this.getMavenRepository().storeItem(false, new DefaultStorageFileItem(this.getMavenRepository(), req, true, true, (ContentLocator)new StringContentLocator(md5Hash)));
            }
        }
        catch (ItemNotFoundException e) {
            throw new LocalStorageException("Storage inconsistency!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItemWithChecksums(boolean fromTask, ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        block14: {
            try {
                this.getMavenRepository().deleteItem(fromTask, request);
            }
            catch (ItemNotFoundException e) {
                if (request.getRequestPath().endsWith(".asc")) break block14;
                throw e;
            }
        }
        request.pushRequestPath(request.getRequestPath() + ".sha1");
        try {
            this.getMavenRepository().deleteItem(fromTask, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        finally {
            request.popRequestPath();
        }
        request.pushRequestPath(request.getRequestPath() + ".md5");
        try {
            this.getMavenRepository().deleteItem(fromTask, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        finally {
            request.popRequestPath();
        }
        if (!request.getRequestPath().endsWith(".asc")) {
            request.pushRequestPath(request.getRequestPath() + ".asc");
            try {
                this.deleteItemWithChecksums(fromTask, request);
            }
            finally {
                request.popRequestPath();
            }
        }
    }

    public StorageFileItem retrieveArtifactPom(ArtifactStoreRequest gavRequest) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        Gav pomGav = new Gav(gavRequest.getGav().getGroupId(), gavRequest.getGav().getArtifactId(), gavRequest.getGav().getVersion(), null, "pom", gavRequest.getGav().getSnapshotBuildNumber(), gavRequest.getGav().getSnapshotTimeStamp(), gavRequest.getGav().getName(), gavRequest.getGav().isHash(), gavRequest.getGav().getHashType(), gavRequest.getGav().isSignature(), gavRequest.getGav().getSignatureType());
        ArtifactStoreRequest pomRequest = new ArtifactStoreRequest(gavRequest.getMavenRepository(), pomGav, gavRequest.isRequestLocalOnly(), gavRequest.isRequestRemoteOnly());
        return this.retrieveArtifact(pomRequest);
    }

    public Gav resolveArtifact(ArtifactStoreRequest gavRequest) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkRequest(gavRequest);
        try {
            Gav gav = this.repository.getMetadataManager().resolveArtifact(gavRequest);
            if (gav == null) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor((ResourceStoreRequest)gavRequest, this.repository, "Request %s is not resolvable in repository %s", gavRequest.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(this.repository)));
            }
            return gav;
        }
        catch (IOException e) {
            throw new LocalStorageException("Could not maintain metadata!", e);
        }
    }

    public StorageFileItem retrieveArtifact(ArtifactStoreRequest gavRequest) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkRequest(gavRequest);
        Gav gav = this.resolveArtifact(gavRequest);
        gavRequest.setRequestPath(this.repository.getGavCalculator().gavToPath(gav));
        StorageItem item = this.repository.retrieveItem(gavRequest);
        if (StorageFileItem.class.isAssignableFrom(item.getClass())) {
            return (StorageFileItem)item;
        }
        throw new LocalStorageException("The Artifact retrieval returned non-file, path:" + item.getRepositoryItemUid().toString());
    }

    public void storeArtifactPom(ArtifactStoreRequest gavRequest, InputStream is, Map<String, String> attributes) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkRequest(gavRequest);
        Gav gav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), gavRequest.getVersion(), gavRequest.getClassifier(), "pom", null, null, null, false, null, false, null);
        gavRequest.setRequestPath(this.repository.getGavCalculator().gavToPath(gav));
        this.repository.storeItemWithChecksums(gavRequest, is, attributes);
        try {
            this.repository.getMetadataManager().deployArtifact(gavRequest);
        }
        catch (IOException e) {
            throw new LocalStorageException("Could not maintain metadata!", e);
        }
    }

    public void storeArtifact(ArtifactStoreRequest gavRequest, InputStream is, Map<String, String> attributes) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkRequest(gavRequest);
        Gav gav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), gavRequest.getVersion(), gavRequest.getClassifier(), gavRequest.getExtension(), null, null, null, false, null, false, null);
        gavRequest.setRequestPath(this.repository.getGavCalculator().gavToPath(gav));
        this.repository.storeItemWithChecksums(gavRequest, is, attributes);
    }

    public void storeArtifactWithGeneratedPom(ArtifactStoreRequest gavRequest, String packaging, InputStream is, Map<String, String> attributes) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkRequest(gavRequest);
        Gav pomGav = new Gav(gavRequest.getGroupId(), gavRequest.getArtifactId(), gavRequest.getVersion(), null, "pom", null, null, null, false, null, false, null);
        ArtifactStoreRequest pomRequest = new ArtifactStoreRequest(gavRequest.getMavenRepository(), pomGav, false);
        pomRequest.getRequestContext().setParentContext(gavRequest.getRequestContext());
        try {
            this.repository.retrieveItem(false, pomRequest);
        }
        catch (ItemNotFoundException e) {
            if (StringUtils.isBlank((String)packaging)) {
                throw new IllegalArgumentException("Cannot generate POM without valid 'packaging'!");
            }
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(gavRequest.getGroupId());
            model.setArtifactId(gavRequest.getArtifactId());
            model.setVersion(gavRequest.getVersion());
            model.setPackaging(packaging);
            model.setDescription("POM was created by Sonatype Nexus");
            StringWriter sw = new StringWriter();
            MavenXpp3Writer mw = new MavenXpp3Writer();
            try {
                mw.write((Writer)sw, model);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.repository.storeItemWithChecksums(pomRequest, new ByteArrayInputStream(sw.toString().getBytes()), attributes);
            try {
                this.repository.getMetadataManager().deployArtifact(pomRequest);
            }
            catch (IOException ex) {
                throw new LocalStorageException("Could not maintain metadata!", ex);
            }
        }
        gavRequest.setRequestPath(this.repository.getGavCalculator().gavToPath(gavRequest.getGav()));
        this.repository.storeItemWithChecksums(gavRequest, is, attributes);
    }

    protected void checkRequest(ArtifactStoreRequest gavRequest) {
        if (gavRequest.getGroupId() == null || gavRequest.getArtifactId() == null || gavRequest.getVersion() == null) {
            throw new IllegalArgumentException("GAV is not supplied or only partially supplied! (G: '" + gavRequest.getGroupId() + "', A: '" + gavRequest.getArtifactId() + "', V: '" + gavRequest.getVersion() + "')");
        }
    }
}

