/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.proxy.maven.ChecksumContentValidator;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepositoryConfigurator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.validator.FileTypeItemContentValidator;

public abstract class AbstractMavenRepositoryConfigurator
extends AbstractProxyRepositoryConfigurator {
    private ChecksumContentValidator checksumValidator;
    private FileTypeItemContentValidator fileTypeItemContentValidator;

    @Inject
    public void populateAbstractMavenRepositoryConfigurator(ChecksumContentValidator checksumValidator, FileTypeItemContentValidator fileTypeItemContentValidator) {
        this.checksumValidator = (ChecksumContentValidator)Preconditions.checkNotNull((Object)checksumValidator);
        this.fileTypeItemContentValidator = (FileTypeItemContentValidator)Preconditions.checkNotNull((Object)fileTypeItemContentValidator);
    }

    @Override
    public void doApplyConfiguration(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfiguration) throws ConfigurationException {
        super.doApplyConfiguration(repository, configuration, coreConfiguration);
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            ProxyRepository proxy = repository.adaptToFacet(ProxyRepository.class);
            proxy.getItemContentValidators().put("checksum", this.checksumValidator);
            proxy.getItemContentValidators().put("filetypevalidator", this.fileTypeItemContentValidator);
        }
    }
}

