/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepositoryConfiguration;

public abstract class AbstractMavenRepositoryConfiguration
extends AbstractProxyRepositoryConfiguration {
    public static final String REPOSITORY_POLICY = "repositoryPolicy";
    public static final String CHECKSUM_POLICY = "checksumPolicy";
    public static final String ARTIFACT_MAX_AGE = "artifactMaxAge";
    public static final String METADATA_MAX_AGE = "metadataMaxAge";
    public static final String DOWNLOAD_REMOTE_INDEX = "downloadRemoteIndex";
    public static final String CLEANSE_REPOSITORY_METADATA = "cleanseRepositoryMetadata";
    public static final String ROUTING_DISCOVERY_ENABLED = "routingDiscoveryEnabled";
    public static final String ROUTING_DISCOVERY_INTERVAL = "routingDiscoveryInterval";

    public AbstractMavenRepositoryConfiguration(Xpp3Dom configuration) {
        super(configuration);
    }

    public RepositoryPolicy getRepositoryPolicy() {
        return RepositoryPolicy.valueOf(this.getNodeValue(this.getRootNode(), REPOSITORY_POLICY, RepositoryPolicy.RELEASE.toString()).toUpperCase());
    }

    public void setRepositoryPolicy(RepositoryPolicy policy) {
        this.setNodeValue(this.getRootNode(), REPOSITORY_POLICY, policy.toString());
    }

    public ChecksumPolicy getChecksumPolicy() {
        return ChecksumPolicy.valueOf(this.getNodeValue(this.getRootNode(), CHECKSUM_POLICY, ChecksumPolicy.WARN.toString()));
    }

    public void setChecksumPolicy(ChecksumPolicy policy) {
        this.setNodeValue(this.getRootNode(), CHECKSUM_POLICY, policy.toString());
    }

    public int getArtifactMaxAge() {
        return Integer.parseInt(this.getNodeValue(this.getRootNode(), ARTIFACT_MAX_AGE, "1440"));
    }

    public void setArtifactMaxAge(int age) {
        this.setNodeValue(this.getRootNode(), ARTIFACT_MAX_AGE, String.valueOf(age));
    }

    public int getMetadataMaxAge() {
        return Integer.parseInt(this.getNodeValue(this.getRootNode(), METADATA_MAX_AGE, "1440"));
    }

    public void setMetadataMaxAge(int age) {
        this.setNodeValue(this.getRootNode(), METADATA_MAX_AGE, String.valueOf(age));
    }

    public boolean isDownloadRemoteIndex() {
        return Boolean.parseBoolean(this.getNodeValue(this.getRootNode(), DOWNLOAD_REMOTE_INDEX, Boolean.TRUE.toString()));
    }

    public void setDownloadRemoteIndex(boolean val) {
        this.setNodeValue(this.getRootNode(), DOWNLOAD_REMOTE_INDEX, Boolean.toString(val));
    }

    public boolean isCleanseRepositoryMetadata() {
        return Boolean.parseBoolean(this.getNodeValue(this.getRootNode(), CLEANSE_REPOSITORY_METADATA, Boolean.FALSE.toString()));
    }

    public void setCleanseRepositoryMetadata(boolean val) {
        this.setNodeValue(this.getRootNode(), CLEANSE_REPOSITORY_METADATA, Boolean.toString(val));
    }

    public boolean isRoutingDiscoveryEnabled() {
        return Boolean.parseBoolean(this.getNodeValue(this.getRootNode(), ROUTING_DISCOVERY_ENABLED, Boolean.TRUE.toString()));
    }

    public void setRoutingDiscoveryEnabled(boolean val) {
        this.setNodeValue(this.getRootNode(), ROUTING_DISCOVERY_ENABLED, Boolean.toString(val));
    }

    public long getRoutingDiscoveryInterval() {
        return Long.parseLong(this.getNodeValue(this.getRootNode(), ROUTING_DISCOVERY_INTERVAL, String.valueOf(TimeUnit.HOURS.toMillis(24L))));
    }

    public void setRoutingDiscoveryInterval(long val) {
        this.setNodeValue(this.getRootNode(), ROUTING_DISCOVERY_INTERVAL, String.valueOf(val));
    }
}

