/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryEventEvictUnusedItems;
import org.sonatype.nexus.proxy.events.RepositoryEventRecreateMavenMetadata;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.ArtifactStoreHelper;
import org.sonatype.nexus.proxy.maven.ChecksumContentValidator;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.EvictUnusedMavenItemsWalkerProcessor;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MetadataManager;
import org.sonatype.nexus.proxy.maven.RecreateMavenMetadataWalkerProcessor;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.ProxyRequestFilter;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.MutableProxyRepositoryKind;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public abstract class AbstractMavenRepository
extends AbstractProxyRepository
implements MavenRepository,
MavenHostedRepository,
MavenProxyRepository {
    private MetadataManager metadataManager;
    private ArtifactPackagingMapper artifactPackagingMapper;
    private ProxyRequestFilter proxyRequestFilter;
    private MutableProxyRepositoryKind repositoryKind;
    private ArtifactStoreHelper artifactStoreHelper;
    private boolean downloadRemoteIndexEnabled = false;

    @Inject
    public void populateAbstractMavenRepository(MetadataManager metadataManager, ArtifactPackagingMapper artifactPackagingMapper, ProxyRequestFilter proxyRequestFilter) {
        this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager);
        this.artifactPackagingMapper = (ArtifactPackagingMapper)Preconditions.checkNotNull((Object)artifactPackagingMapper);
        this.proxyRequestFilter = (ProxyRequestFilter)Preconditions.checkNotNull((Object)proxyRequestFilter);
        this.repositoryKind = new MutableProxyRepositoryKind(this, Arrays.asList(MavenRepository.class), new DefaultRepositoryKind(MavenHostedRepository.class, null), new DefaultRepositoryKind(MavenProxyRepository.class, null));
        this.artifactStoreHelper = new ArtifactStoreHelper(this);
    }

    @Override
    protected AbstractMavenRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        return (AbstractMavenRepositoryConfiguration)super.getExternalConfiguration(forModification);
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean result = super.commitChanges();
        if (result) {
            this.downloadRemoteIndexEnabled = false;
        }
        return result;
    }

    @Override
    public boolean rollbackChanges() {
        this.downloadRemoteIndexEnabled = false;
        return super.rollbackChanges();
    }

    @Override
    protected RepositoryConfigurationUpdatedEvent getRepositoryConfigurationUpdatedEvent() {
        RepositoryConfigurationUpdatedEvent event = super.getRepositoryConfigurationUpdatedEvent();
        event.setDownloadRemoteIndexEnabled(this.downloadRemoteIndexEnabled);
        return event;
    }

    @Override
    public ArtifactStoreHelper getArtifactStoreHelper() {
        return this.artifactStoreHelper;
    }

    @Override
    public ArtifactPackagingMapper getArtifactPackagingMapper() {
        return this.artifactPackagingMapper;
    }

    protected ProxyRequestFilter getProxyRequestFilter() {
        return this.proxyRequestFilter;
    }

    @Override
    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    @Override
    protected Collection<String> doEvictUnusedItems(ResourceStoreRequest request, long timestamp) {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            Collection<String> result = this.doEvictUnusedItems(request, timestamp, new EvictUnusedMavenItemsWalkerProcessor(timestamp), new EvictUnusedMavenItemsWalkerProcessor.EvictUnusedMavenItemsWalkerFilter());
            this.eventBus().post((Object)new RepositoryEventEvictUnusedItems(this));
            return result;
        }
        return super.doEvictUnusedItems(request, timestamp);
    }

    @Override
    public boolean recreateMavenMetadata(ResourceStoreRequest request) {
        if (!this.shouldServiceOperation(request, "recreateMavenMetadata")) {
            return false;
        }
        if (!this.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
            this.log.debug("Not performing recreateMavenMetadata, {} is not hosted.", (Object)this);
            return false;
        }
        if (StringUtils.isEmpty((String)request.getRequestPath())) {
            request.setRequestPath("/");
        }
        try {
            if (!this.getLocalStorage().containsItem(this, request)) {
                this.log.info("Skip rebuilding Maven2 Metadata in repository {} because it does not contain path='{}'.", (Object)this, (Object)request.getRequestPath());
                return false;
            }
        }
        catch (LocalStorageException e) {
            this.log.warn("Skip rebuilding Maven2 Metadata in repository {}", (Object)this, (Object)e);
            return false;
        }
        return this.doRecreateMavenMetadata(request);
    }

    protected boolean doRecreateMavenMetadata(ResourceStoreRequest request) {
        DefaultWalkerContext ctx;
        block2: {
            this.log.info("Recreating Maven2 metadata in hosted repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
            RecreateMavenMetadataWalkerProcessor wp = new RecreateMavenMetadataWalkerProcessor(this.log);
            ctx = new DefaultWalkerContext(this, request);
            ctx.getProcessors().add(wp);
            try {
                this.getWalker().walk(ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block2;
                throw e;
            }
        }
        this.eventBus().post((Object)new RepositoryEventRecreateMavenMetadata(this));
        return !ctx.isStopped();
    }

    @Override
    public boolean isDownloadRemoteIndexes() {
        return this.getExternalConfiguration(false).isDownloadRemoteIndex();
    }

    @Override
    public void setDownloadRemoteIndexes(boolean downloadRemoteIndexes) {
        boolean oldValue = this.isDownloadRemoteIndexes();
        boolean newValue = downloadRemoteIndexes;
        this.getExternalConfiguration(true).setDownloadRemoteIndex(downloadRemoteIndexes);
        if (!oldValue && newValue) {
            this.downloadRemoteIndexEnabled = true;
        }
    }

    @Override
    public RepositoryPolicy getRepositoryPolicy() {
        return this.getExternalConfiguration(false).getRepositoryPolicy();
    }

    @Override
    public void setRepositoryPolicy(RepositoryPolicy repositoryPolicy) {
        this.getExternalConfiguration(true).setRepositoryPolicy(repositoryPolicy);
    }

    @Override
    public boolean isCleanseRepositoryMetadata() {
        return this.getExternalConfiguration(false).isCleanseRepositoryMetadata();
    }

    @Override
    public void setCleanseRepositoryMetadata(boolean cleanseRepositoryMetadata) {
        this.getExternalConfiguration(true).setCleanseRepositoryMetadata(cleanseRepositoryMetadata);
    }

    @Override
    public ChecksumPolicy getChecksumPolicy() {
        return this.getExternalConfiguration(false).getChecksumPolicy();
    }

    @Override
    public void setChecksumPolicy(ChecksumPolicy checksumPolicy) {
        this.getExternalConfiguration(true).setChecksumPolicy(checksumPolicy);
    }

    @Override
    public int getArtifactMaxAge() {
        return this.getExternalConfiguration(false).getArtifactMaxAge();
    }

    @Override
    public void setArtifactMaxAge(int maxAge) {
        this.getExternalConfiguration(true).setArtifactMaxAge(maxAge);
    }

    @Override
    public int getMetadataMaxAge() {
        return this.getExternalConfiguration(false).getMetadataMaxAge();
    }

    @Override
    public void setMetadataMaxAge(int metadataMaxAge) {
        this.getExternalConfiguration(true).setMetadataMaxAge(metadataMaxAge);
    }

    @Override
    public boolean isMavenArtifact(StorageItem item) {
        return this.isMavenArtifactPath(item.getPath());
    }

    @Override
    public boolean isMavenMetadata(StorageItem item) {
        return this.isMavenMetadataPath(item.getPath());
    }

    @Override
    public boolean isMavenArtifactPath(String path) {
        return this.getGavCalculator().pathToGav(path) != null;
    }

    @Override
    public abstract boolean isMavenMetadataPath(String var1);

    public abstract boolean isMavenArtifactChecksumPath(String var1);

    public abstract boolean shouldServeByPolicies(ResourceStoreRequest var1);

    @Override
    public void storeItemWithChecksums(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("storeItemWithChecksums() :: " + request.getRequestPath());
        }
        this.getArtifactStoreHelper().storeItemWithChecksums(request, is, userAttributes);
    }

    @Override
    public void deleteItemWithChecksums(ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("deleteItemWithChecksums() :: " + request.getRequestPath());
        }
        this.getArtifactStoreHelper().deleteItemWithChecksums(request);
    }

    @Override
    public void storeItemWithChecksums(boolean fromTask, AbstractStorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("storeItemWithChecksums() :: " + item.getRepositoryItemUid().toString());
        }
        this.getArtifactStoreHelper().storeItemWithChecksums(fromTask, item);
    }

    @Override
    public void deleteItemWithChecksums(boolean fromTask, ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("deleteItemWithChecksums() :: " + request.toString());
        }
        this.getArtifactStoreHelper().deleteItemWithChecksums(fromTask, request);
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (!this.shouldServeByPolicies(request)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The serving of item " + request.toString() + " is forbidden by Maven repository policy.");
            }
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Retrieval of %s from %s is forbidden by repository policy %s.", new Object[]{request.getRequestPath(), this, this.getRepositoryPolicy()}));
        }
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && !request.getRequestPath().startsWith("/.")) {
            if (request.getRequestPath().endsWith(".sha1")) {
                return ChecksumContentValidator.doRetrieveSHA1(this, request, this.doRetrieveArtifactItem(request, ".sha1")).getHashItem();
            }
            if (request.getRequestPath().endsWith(".md5")) {
                return ChecksumContentValidator.doRetrieveMD5(this, request, this.doRetrieveArtifactItem(request, ".md5")).getHashItem();
            }
        }
        return super.doRetrieveItem(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageItem doRetrieveArtifactItem(ResourceStoreRequest hashRequest, String suffix) throws ItemNotFoundException, StorageException, IllegalOperationException {
        String hashPath = hashRequest.getRequestPath();
        String itemPath = hashPath.substring(0, hashPath.length() - suffix.length());
        hashRequest.pushRequestPath(itemPath);
        try {
            StorageItem storageItem = super.doRetrieveItem(hashRequest);
            return storageItem;
        }
        finally {
            hashRequest.popRequestPath();
        }
    }

    @Override
    protected void shouldTryRemote(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException {
        boolean proxyFilterAllowed;
        super.shouldTryRemote(request);
        RepositoryItemUid uid = this.createUid(request.getRequestPath());
        if (!(uid.getBooleanAttributeValue(IsHiddenAttribute.class) || request.getRequestContext().containsKey(Manager.ROUTING_REQUEST_NFS_FLAG_KEY) || (proxyFilterAllowed = this.getProxyRequestFilter().allowed(this, request)))) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Automatic routing filter rejected remote request for path %s from %s", request.getRequestPath(), this));
        }
    }

    @Override
    public void storeItem(boolean fromTask, StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        block8: {
            ResourceStoreRequest request = new ResourceStoreRequest(item);
            if (this.shouldServeByPolicies(request)) {
                if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && item instanceof StorageFileItem && !item.getPath().startsWith("/.")) {
                    try {
                        if (item.getPath().endsWith(".sha1")) {
                            ChecksumContentValidator.doStoreSHA1(this, this.doRetrieveArtifactItem(request, ".sha1"), (StorageFileItem)item);
                            break block8;
                        }
                        if (item.getPath().endsWith(".md5")) {
                            ChecksumContentValidator.doStoreMD5(this, this.doRetrieveArtifactItem(request, ".md5"), (StorageFileItem)item);
                            break block8;
                        }
                        super.storeItem(fromTask, item);
                    }
                    catch (ItemNotFoundException itemNotFoundException) {}
                } else {
                    super.storeItem(fromTask, item);
                }
            } else {
                String msg = "Storing of item " + item.getRepositoryItemUid().toString() + " is forbidden by Maven Repository policy. Because " + this.getId() + " is a " + this.getRepositoryPolicy().name() + " repository";
                this.log.info(msg);
                throw new UnsupportedStorageOperationException(msg);
            }
        }
    }

    @Override
    public AbstractStorageItem doCacheItem(AbstractStorageItem item) throws LocalStorageException {
        AbstractStorageItem result = super.doCacheItem(item);
        result.getRepositoryItemAttributes().remove("remote.sha1");
        result.getRepositoryItemAttributes().remove("remote.md5");
        return result;
    }

    @Override
    protected boolean doExpireProxyCaches(ResourceStoreRequest request, WalkerFilter filter) {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && request.getRequestPath() != null && !request.getRequestPath().startsWith("/.")) {
            if (request.getRequestPath().endsWith(".sha1")) {
                this.expireRemoteHash(request, ".sha1");
            } else if (request.getRequestPath().endsWith(".md5")) {
                this.expireRemoteHash(request, ".md5");
            }
        }
        return super.doExpireProxyCaches(request, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireRemoteHash(ResourceStoreRequest hashRequest, String suffix) {
        String hashPath = hashRequest.getRequestPath();
        String itemPath = hashPath.substring(0, hashPath.length() - suffix.length());
        hashRequest.pushRequestPath(itemPath);
        try {
            AbstractStorageItem artifact = this.getLocalStorage().retrieveItem(this, hashRequest);
            Attributes attributes = artifact.getRepositoryItemAttributes();
            if (attributes.containsKey("remote.sha1") || attributes.containsKey("remote.md5")) {
                attributes.put("remote.hash.expired", "true");
                this.getAttributesHandler().storeAttributes(artifact);
            }
        }
        catch (Exception e) {
            this.log.debug("Skip expiring remote hash in repository {} because it does not contain path='{}'.", (Object)this, (Object)itemPath);
        }
        finally {
            hashRequest.popRequestPath();
        }
    }

    @Override
    public boolean isCompatible(Repository repository) {
        return super.isCompatible(repository) && MavenRepository.class.isAssignableFrom(repository.getClass()) && this.getRepositoryPolicy().equals((Object)((MavenRepository)repository).getRepositoryPolicy());
    }

    @Override
    protected Collection<StorageItem> doListItems(ResourceStoreRequest request) throws ItemNotFoundException, StorageException {
        Collection<StorageItem> items = super.doListItems(request);
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            TreeMap<String, StorageItem> result = new TreeMap<String, StorageItem>();
            for (StorageItem item : items) {
                this.putChecksumItem(result, request, item, "remote.sha1", ".sha1");
                this.putChecksumItem(result, request, item, "remote.md5", ".md5");
            }
            for (StorageItem item : items) {
                if (result.containsKey(item.getPath())) continue;
                result.put(item.getPath(), item);
            }
            items = result.values();
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChecksumItem(Map<String, StorageItem> checksums, ResourceStoreRequest request, StorageItem artifact, String attrname, String suffix) {
        String hash = artifact.getRepositoryItemAttributes().get(attrname);
        if (hash != null) {
            String hashPath = artifact.getPath() + suffix;
            request.pushRequestPath(hashPath);
            try {
                checksums.put(hashPath, ChecksumContentValidator.newHashItem(this, request, artifact, hash));
            }
            finally {
                request.popRequestPath();
            }
        }
    }

    @Override
    protected boolean shouldAddToNotFoundCache(ResourceStoreRequest request) {
        boolean shouldAddToNFC = super.shouldAddToNotFoundCache(request);
        if (shouldAddToNFC && request.getRequestContext().containsKey(Manager.ROUTING_REQUEST_REJECTED_FLAG_KEY)) {
            request.getRequestContext().remove(Manager.ROUTING_REQUEST_REJECTED_FLAG_KEY);
            shouldAddToNFC = false;
            this.log.debug("Maven proxy repository {} autorouting rejected this request, not adding path {} to NFC.", (Object)RepositoryStringUtils.getHumanizedNameString(this), (Object)request.getRequestPath());
        }
        return shouldAddToNFC;
    }

    @Override
    protected boolean shouldNeglectItemNotFoundExOnDelete(ResourceStoreRequest request, ItemNotFoundException ex) {
        return this.isMavenArtifactChecksumPath(request.getRequestPath());
    }

    @Override
    protected void doDeleteItem(ResourceStoreRequest request) throws UnsupportedStorageOperationException, ItemNotFoundException, StorageException {
        block6: {
            try {
                super.doDeleteItem(request);
            }
            catch (ItemNotFoundException ex) {
                if (this.shouldNeglectItemNotFoundExOnDelete(request, ex)) break block6;
                throw ex;
            }
        }
        if (request.isExternal() && this.getRepositoryKind().isFacetAvailable(MavenHostedRepository.class)) {
            String parentPath = request.getRequestPath();
            parentPath = parentPath.substring(0, parentPath.lastIndexOf("/"));
            String parentMetadataPath = parentPath + "/maven-metadata.xml";
            try {
                if (this.getLocalStorage().containsItem(this, new ResourceStoreRequest(parentMetadataPath))) {
                    this.recreateMavenMetadata(new ResourceStoreRequest(parentPath));
                }
            }
            catch (Exception e) {
                this.log.warn("Could not maintain Maven metadata '{}'", (Object)parentMetadataPath, (Object)e);
            }
        }
    }
}

