/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.AbstractMavenGroupRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.ArtifactStoreHelper;
import org.sonatype.nexus.proxy.maven.MavenGroupRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MetadataManager;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.packaging.ArtifactPackagingMapper;
import org.sonatype.nexus.proxy.repository.AbstractGroupRepository;
import org.sonatype.nexus.proxy.repository.DefaultRepositoryKind;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryKind;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

public abstract class AbstractMavenGroupRepository
extends AbstractGroupRepository
implements MavenGroupRepository {
    private MetadataManager metadataManager;
    private ArtifactPackagingMapper artifactPackagingMapper;
    private ArtifactStoreHelper artifactStoreHelper;
    private RepositoryKind repositoryKind;

    @Inject
    public void populateAbstractMavenGroupRepository(MetadataManager metadataManager, ArtifactPackagingMapper artifactPackagingMapper) {
        this.metadataManager = (MetadataManager)Preconditions.checkNotNull((Object)metadataManager);
        this.artifactPackagingMapper = (ArtifactPackagingMapper)Preconditions.checkNotNull((Object)artifactPackagingMapper);
        this.artifactStoreHelper = new ArtifactStoreHelper(this);
        this.repositoryKind = new DefaultRepositoryKind(GroupRepository.class, Arrays.asList(MavenGroupRepository.class));
    }

    @Override
    protected AbstractMavenGroupRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (AbstractMavenGroupRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    @Override
    public RepositoryKind getRepositoryKind() {
        return this.repositoryKind;
    }

    @Override
    public boolean isMergeMetadata() {
        return this.getExternalConfiguration(false).isMergeMetadata();
    }

    @Override
    public void setMergeMetadata(boolean mergeMetadata) {
        this.getExternalConfiguration(true).setMergeMetadata(mergeMetadata);
    }

    @Override
    public ArtifactPackagingMapper getArtifactPackagingMapper() {
        return this.artifactPackagingMapper;
    }

    @Override
    public ArtifactStoreHelper getArtifactStoreHelper() {
        return this.artifactStoreHelper;
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public boolean recreateMavenMetadata(ResourceStoreRequest request) {
        if (!this.shouldServiceOperation(request, "recreateMavenMetadata")) {
            return false;
        }
        boolean result = false;
        for (Repository repository : this.getMemberRepositories()) {
            if (!repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) continue;
            result |= ((MavenRepository)repository).recreateMavenMetadata(request);
        }
        return result;
    }

    @Override
    public RepositoryPolicy getRepositoryPolicy() {
        return RepositoryPolicy.MIXED;
    }

    @Override
    public void setRepositoryPolicy(RepositoryPolicy repositoryPolicy) {
        throw new UnsupportedOperationException("Setting repository policy on a Maven group repository is not possible!");
    }

    @Override
    public boolean isMavenArtifact(StorageItem item) {
        return this.isMavenArtifactPath(item.getPath());
    }

    @Override
    public boolean isMavenMetadata(StorageItem item) {
        return this.isMavenMetadataPath(item.getPath());
    }

    @Override
    public boolean isMavenArtifactPath(String path) {
        return this.getGavCalculator().pathToGav(path) != null;
    }

    @Override
    public abstract boolean isMavenMetadataPath(String var1);

    @Override
    public void storeItemWithChecksums(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        this.getArtifactStoreHelper().storeItemWithChecksums(request, is, userAttributes);
    }

    @Override
    public void storeItemWithChecksums(boolean fromTask, AbstractStorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        this.getArtifactStoreHelper().storeItemWithChecksums(fromTask, item);
    }

    @Override
    public void deleteItemWithChecksums(ResourceStoreRequest request) throws UnsupportedStorageOperationException, ItemNotFoundException, IllegalOperationException, StorageException, AccessDeniedException {
        this.getArtifactStoreHelper().deleteItemWithChecksums(request);
    }

    @Override
    public void deleteItemWithChecksums(boolean fromTask, ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        this.getArtifactStoreHelper().deleteItemWithChecksums(fromTask, request);
    }
}

