/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven;

import java.util.List;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEvent;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.MavenChecksumContentValidationEventFailed;
import org.sonatype.nexus.proxy.maven.RemoteHashResponse;
import org.sonatype.nexus.proxy.repository.ItemContentValidator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class AbstractChecksumContentValidator
extends ComponentSupport
implements ItemContentValidator {
    @Override
    public boolean isRemoteItemContentValid(ProxyRepository proxy, ResourceStoreRequest req, String baseUrl, AbstractStorageItem item, List<RepositoryItemValidationEvent> events) throws LocalStorageException {
        boolean contentValid;
        String msg;
        ChecksumPolicy checksumPolicy = this.getChecksumPolicy(proxy, item);
        ChecksumPolicy requestChecksumPolicy = (ChecksumPolicy)((Object)req.getRequestContext().get(ChecksumPolicy.REQUEST_CHECKSUM_POLICY_KEY));
        if (requestChecksumPolicy != null) {
            checksumPolicy = requestChecksumPolicy;
        }
        if (checksumPolicy == null || !checksumPolicy.shouldCheckChecksum()) {
            return true;
        }
        RemoteHashResponse remoteHash = this.retrieveRemoteHash(item, proxy, baseUrl);
        if (remoteHash == null && ChecksumPolicy.STRICT.equals((Object)checksumPolicy)) {
            msg = "The artifact " + item.getPath() + " has no remote checksum in repository " + item.getRepositoryId() + "! The checksumPolicy of repository forbids downloading of it.";
            contentValid = false;
        } else if (remoteHash == null) {
            msg = "Warning, the artifact " + item.getPath() + " has no remote checksum in repository " + item.getRepositoryId() + "!";
            contentValid = true;
        } else {
            if (remoteHash.getRemoteHash().equals(this.retrieveLocalHash(item, remoteHash.getInspector()))) {
                return true;
            }
            if (ChecksumPolicy.WARN.equals((Object)checksumPolicy)) {
                msg = "Warning, the artifact " + item.getPath() + " and it's remote checksums does not match in repository " + item.getRepositoryId() + "!";
                contentValid = true;
            } else {
                msg = "The artifact " + item.getPath() + " and it's remote checksums does not match in repository " + item.getRepositoryId() + "! The checksumPolicy of repository forbids downloading of it.";
                contentValid = false;
            }
        }
        if (!contentValid) {
            this.log.debug("Validation failed due: " + msg);
        }
        events.add(this.newChechsumFailureEvent(proxy, item, msg));
        this.cleanup(proxy, remoteHash, contentValid);
        return contentValid;
    }

    protected String retrieveLocalHash(AbstractStorageItem item, String inspector) {
        return item.getRepositoryItemAttributes().get(inspector);
    }

    protected abstract void cleanup(ProxyRepository var1, RemoteHashResponse var2, boolean var3) throws LocalStorageException;

    protected abstract RemoteHashResponse retrieveRemoteHash(AbstractStorageItem var1, ProxyRepository var2, String var3) throws LocalStorageException;

    protected abstract ChecksumPolicy getChecksumPolicy(ProxyRepository var1, AbstractStorageItem var2) throws LocalStorageException;

    private RepositoryItemValidationEvent newChechsumFailureEvent(ProxyRepository proxy, AbstractStorageItem item, String msg) {
        return new MavenChecksumContentValidationEventFailed(proxy, item, msg);
    }
}

