/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;

public class RepositoryPathMapping {
    private String id;
    private MappingType mappingType;
    private String groupId;
    private List<Pattern> patterns;
    private List<String> mappedRepositories;

    public RepositoryPathMapping(String id, MappingType mappingType, String groupId, List<String> regexps, List<String> mappedRepositories) throws PatternSyntaxException {
        this.id = id;
        this.mappingType = mappingType;
        this.groupId = StringUtils.isBlank((String)groupId) || "*".equals(groupId) ? "*" : groupId;
        this.patterns = new ArrayList<Pattern>(regexps.size());
        for (String regexp : regexps) {
            if (!StringUtils.isNotEmpty((String)regexp)) continue;
            this.patterns.add(Pattern.compile(regexp));
        }
        this.mappedRepositories = mappedRepositories;
    }

    public boolean isAllGroups() {
        return "*".equals(this.getGroupId());
    }

    public boolean matches(Repository repository, ResourceStoreRequest request) {
        if (this.isAllGroups() || repository.getRepositoryKind().isFacetAvailable(GroupRepository.class) && this.groupId.equals(repository.getId())) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(request.getRequestPath()).matches()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public MappingType getMappingType() {
        return this.mappingType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public List<String> getMappedRepositories() {
        return this.mappedRepositories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getId());
        sb.append("=[");
        sb.append("type=");
        sb.append(this.getMappingType().toString());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", patterns=");
        sb.append(this.getPatterns().toString());
        sb.append(", mappedRepositories=");
        sb.append(this.getMappedRepositories());
        sb.append("]");
        return sb.toString();
    }

    public static enum MappingType {
        BLOCKING,
        INCLUSION,
        EXCLUSION;

    }
}

