/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.mapping;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.AbstractLastingConfigurable;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CPathMappingItem;
import org.sonatype.nexus.configuration.model.CRepositoryGrouping;
import org.sonatype.nexus.configuration.model.CRepositoryGroupingCoreConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationConfigurationValidator;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.mapping.RepositoryPathMapping;
import org.sonatype.nexus.proxy.mapping.RequestRepositoryMapper;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultRequestRepositoryMapper
extends AbstractLastingConfigurable<CRepositoryGrouping>
implements RequestRepositoryMapper {
    private final RepositoryRegistry repositoryRegistry;
    private final ApplicationConfigurationValidator validator;
    private volatile boolean compiled = false;
    private volatile List<RepositoryPathMapping> blockings = new CopyOnWriteArrayList<RepositoryPathMapping>();
    private volatile List<RepositoryPathMapping> inclusions = new CopyOnWriteArrayList<RepositoryPathMapping>();
    private volatile List<RepositoryPathMapping> exclusions = new CopyOnWriteArrayList<RepositoryPathMapping>();

    @Inject
    public DefaultRequestRepositoryMapper(EventBus eventBus, ApplicationConfiguration applicationConfiguration, RepositoryRegistry repositoryRegistry, ApplicationConfigurationValidator validator) {
        super("Repository Grouping Configuration", eventBus, applicationConfiguration);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.validator = (ApplicationConfigurationValidator)Preconditions.checkNotNull((Object)validator);
    }

    @Override
    protected void initializeConfiguration() throws ConfigurationException {
        if (this.getApplicationConfiguration().getConfigurationModel() != null) {
            this.configure(this.getApplicationConfiguration());
        }
    }

    @Override
    protected CoreConfiguration<CRepositoryGrouping> wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof ApplicationConfiguration) {
            return new CRepositoryGroupingCoreConfiguration((ApplicationConfiguration)configuration);
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + ApplicationConfiguration.class.getName() + "\"!");
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean wasDirty = super.commitChanges();
        if (wasDirty) {
            this.compiled = false;
        }
        return wasDirty;
    }

    @Override
    public List<Repository> getMappedRepositories(Repository repository, ResourceStoreRequest request, List<Repository> resolvedRepositories) throws NoSuchRepositoryException {
        if (!this.compiled) {
            this.compile();
        }
        LinkedHashSet<String> reposIdSet = new LinkedHashSet<String>(resolvedRepositories.size());
        for (Repository repository2 : resolvedRepositories) {
            reposIdSet.add(repository2.getId());
        }
        boolean firstAdd = true;
        for (RepositoryPathMapping repositoryPathMapping : this.blockings) {
            if (!repositoryPathMapping.matches(repository, request)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("The request path [" + request.toString() + "] is blocked by rule " + repositoryPathMapping.toString());
            }
            request.addAppliedMappingsList(repository, Collections.singletonList(repositoryPathMapping.toString()));
            return Collections.emptyList();
        }
        ArrayList<RepositoryPathMapping> arrayList = new ArrayList<RepositoryPathMapping>();
        for (RepositoryPathMapping repositoryPathMapping : this.inclusions) {
            if (!repositoryPathMapping.matches(repository, request)) continue;
            arrayList.add(repositoryPathMapping);
            if (firstAdd) {
                reposIdSet.clear();
                firstAdd = false;
            }
            if (repositoryPathMapping.getMappedRepositories().size() == 1 && "*".equals(repositoryPathMapping.getMappedRepositories().get(0))) {
                for (Repository repository3 : resolvedRepositories) {
                    reposIdSet.add(repository3.getId());
                }
                continue;
            }
            for (Repository repository4 : resolvedRepositories) {
                if (!repositoryPathMapping.getMappedRepositories().contains(repository4.getId()) && repository4.isUserManaged()) continue;
                reposIdSet.add(repository4.getId());
            }
        }
        for (RepositoryPathMapping repositoryPathMapping : this.exclusions) {
            if (!repositoryPathMapping.matches(repository, request)) continue;
            arrayList.add(repositoryPathMapping);
            if (repositoryPathMapping.getMappedRepositories().size() == 1 && "*".equals(repositoryPathMapping.getMappedRepositories().get(0))) {
                reposIdSet.clear();
                break;
            }
            for (String string : repositoryPathMapping.getMappedRepositories()) {
                Repository mappedRepository = this.repositoryRegistry.getRepository(string);
                if (!mappedRepository.isUserManaged()) continue;
                reposIdSet.remove(mappedRepository.getId());
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (RepositoryPathMapping repositoryPathMapping : arrayList) {
            arrayList2.add(repositoryPathMapping.toString());
        }
        request.addAppliedMappingsList(repository, arrayList2);
        if (this.log.isDebugEnabled()) {
            if (arrayList.isEmpty()) {
                this.log.debug("No mapping exists for request path [" + request.toString() + "]");
            } else {
                StringBuilder stringBuilder = new StringBuilder("Request for path \"" + request.toString() + "\" with the initial list of processable repositories of \"" + this.getResourceStoreListAsString(resolvedRepositories) + "\" got these mappings applied:\n");
                for (RepositoryPathMapping repositoryPathMapping : arrayList) {
                    stringBuilder.append(" * ").append(repositoryPathMapping.toString()).append("\n");
                }
                this.log.debug(stringBuilder.toString());
                if (reposIdSet.size() == 0) {
                    this.log.debug("Mapping for path [" + request.toString() + "] excluded all storages from servicing the request.");
                } else {
                    this.log.debug("Request path for [" + request.toString() + "] is MAPPED to reposes: " + reposIdSet);
                }
            }
        }
        ArrayList<Repository> arrayList3 = new ArrayList<Repository>(reposIdSet.size());
        try {
            for (String string : reposIdSet) {
                arrayList3.add(this.repositoryRegistry.getRepository(string));
            }
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            this.log.error("Some of the Routes contains references to non-existant repositories! Please check the following mappings: \"" + arrayList2.toString() + "\".");
            throw noSuchRepositoryException;
        }
        return arrayList3;
    }

    public String getResourceStoreListAsString(List<? extends ResourceStore> stores) {
        if (stores == null) {
            return "[]";
        }
        ArrayList<String> repoIdList = new ArrayList<String>(stores.size());
        for (ResourceStore resourceStore : stores) {
            if (resourceStore instanceof Repository) {
                repoIdList.add(((Repository)resourceStore).getId());
                continue;
            }
            repoIdList.add(resourceStore.getClass().getName());
        }
        return StringUtils.join(repoIdList.iterator(), (String)", ");
    }

    protected synchronized void compile() throws NoSuchRepositoryException {
        if (this.compiled) {
            return;
        }
        this.blockings.clear();
        this.inclusions.clear();
        this.exclusions.clear();
        if (this.getCurrentConfiguration(false) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No Routes defined, have nothing to compile.");
            }
            return;
        }
        List pathMappings = ((CRepositoryGrouping)this.getCurrentConfiguration(false)).getPathMappings();
        for (CPathMappingItem item : pathMappings) {
            if ("blocking".equals(item.getRouteType())) {
                this.blockings.add(this.convert(item));
                continue;
            }
            if ("inclusive".equals(item.getRouteType())) {
                this.inclusions.add(this.convert(item));
                continue;
            }
            if ("exclusive".equals(item.getRouteType())) {
                this.exclusions.add(this.convert(item));
                continue;
            }
            this.log.warn("Unknown route type: " + item.getRouteType());
            throw new IllegalArgumentException("Unknown route type: " + item.getRouteType());
        }
        this.compiled = true;
    }

    protected RepositoryPathMapping convert(CPathMappingItem item) throws IllegalArgumentException {
        RepositoryPathMapping.MappingType type = null;
        if ("blocking".equals(item.getRouteType())) {
            type = RepositoryPathMapping.MappingType.BLOCKING;
        } else if ("inclusive".equals(item.getRouteType())) {
            type = RepositoryPathMapping.MappingType.INCLUSION;
        } else if ("exclusive".equals(item.getRouteType())) {
            type = RepositoryPathMapping.MappingType.EXCLUSION;
        } else {
            this.log.warn("Unknown route type: " + item.getRouteType());
            throw new IllegalArgumentException("Unknown route type: " + item.getRouteType());
        }
        return new RepositoryPathMapping(item.getId(), type, item.getGroupId(), item.getRoutePatterns(), item.getRepositories());
    }

    protected CPathMappingItem convert(RepositoryPathMapping item) {
        String routeType = null;
        if (RepositoryPathMapping.MappingType.BLOCKING.equals((Object)item.getMappingType())) {
            routeType = "blocking";
        } else if (RepositoryPathMapping.MappingType.INCLUSION.equals((Object)item.getMappingType())) {
            routeType = "inclusive";
        } else if (RepositoryPathMapping.MappingType.EXCLUSION.equals((Object)item.getMappingType())) {
            routeType = "exclusive";
        }
        CPathMappingItem result = new CPathMappingItem();
        result.setId(item.getId());
        result.setGroupId(item.getGroupId());
        result.setRepositories(item.getMappedRepositories());
        result.setRouteType(routeType);
        ArrayList<String> patterns = new ArrayList<String>(item.getPatterns().size());
        for (Pattern pattern : item.getPatterns()) {
            patterns.add(pattern.toString());
        }
        result.setRoutePatterns(patterns);
        return result;
    }

    @Override
    public boolean addMapping(RepositoryPathMapping mapping) throws ConfigurationException {
        this.removeMapping(mapping.getId());
        CPathMappingItem pathItem = this.convert(mapping);
        this.validate(pathItem);
        ((CRepositoryGrouping)this.getCurrentConfiguration(true)).addPathMapping(this.convert(mapping));
        return true;
    }

    protected void validate(CPathMappingItem pathItem) throws InvalidConfigurationException {
        ValidationResponse response = this.validator.validateGroupsSettingPathMappingItem(null, pathItem);
        if (!response.isValid()) {
            throw new InvalidConfigurationException(response);
        }
    }

    @Override
    public boolean removeMapping(String id) {
        Iterator i = ((CRepositoryGrouping)this.getCurrentConfiguration(true)).getPathMappings().iterator();
        while (i.hasNext()) {
            CPathMappingItem mapping = (CPathMappingItem)i.next();
            if (!mapping.getId().equals(id)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public Map<String, RepositoryPathMapping> getMappings() {
        HashMap<String, RepositoryPathMapping> result = new HashMap<String, RepositoryPathMapping>();
        CRepositoryGrouping config = (CRepositoryGrouping)this.getCurrentConfiguration(false);
        if (config != null) {
            List items = config.getPathMappings();
            for (CPathMappingItem item : items) {
                RepositoryPathMapping mapping = this.convert(item);
                result.put(mapping.getId(), mapping);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove evt) {
        String repoId = evt.getRepository().getId();
        List pathMappings = ((CRepositoryGrouping)this.getCurrentConfiguration(true)).getPathMappings();
        Iterator iterator = pathMappings.iterator();
        while (iterator.hasNext()) {
            CPathMappingItem item = (CPathMappingItem)iterator.next();
            if (item.getGroupId().equals(repoId)) {
                iterator.remove();
                continue;
            }
            item.removeRepository(repoId);
        }
    }
}

