/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item.uid;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.uid.Attribute;
import org.sonatype.nexus.proxy.item.uid.RepositoryItemUidAttributeManager;
import org.sonatype.nexus.proxy.item.uid.RepositoryItemUidAttributeSource;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class DefaultRepositoryItemUidAttributeManager
extends ComponentSupport
implements RepositoryItemUidAttributeManager {
    private final Map<String, RepositoryItemUidAttributeSource> attributeSources;
    private final Map<Class<?>, Attribute<?>> attributes;

    @Inject
    public DefaultRepositoryItemUidAttributeManager(Map<String, RepositoryItemUidAttributeSource> attributeSources) {
        this.attributeSources = attributeSources;
        this.attributes = new ConcurrentHashMap();
    }

    @Override
    public <T extends Attribute<?>> T getAttribute(Class<T> attributeKey, RepositoryItemUid subject) {
        return (T)this.attributes.get(attributeKey);
    }

    @Override
    public synchronized void reset() {
        this.attributes.clear();
        ArrayList<String> sources = new ArrayList<String>(this.attributeSources.size());
        for (Map.Entry<String, RepositoryItemUidAttributeSource> attributeSourceEntry : this.attributeSources.entrySet()) {
            sources.add(attributeSourceEntry.getKey());
            Map<Class<?>, Attribute<?>> attrs = attributeSourceEntry.getValue().getAttributes();
            if (attrs == null) continue;
            this.attributes.putAll(attrs);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered {} UID Attributes coming from following sources: {}", new Object[]{this.attributes.size(), sources.toString()});
        }
    }
}

