/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Preconditions;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StringContentLocator;
import org.sonatype.nexus.proxy.repository.Repository;

@Named(value="velocity")
@Singleton
public class VelocityContentGenerator
implements ContentGenerator {
    public static final String ID = "velocity";
    private final Provider<VelocityEngine> velocityEngineProvider;

    @Inject
    public VelocityContentGenerator(Provider<VelocityEngine> velocityEngineProvider) {
        this.velocityEngineProvider = (Provider)Preconditions.checkNotNull(velocityEngineProvider);
    }

    @Override
    public String getGeneratorId() {
        return ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContentLocator generateContent(Repository repository, String path, StorageFileItem item) throws IllegalOperationException, ItemNotFoundException, LocalStorageException {
        StringWriter sw = new StringWriter();
        VelocityContext vctx = new VelocityContext(item.getItemContext().flatten());
        try (InputStreamReader isr = new InputStreamReader(item.getInputStream(), "UTF-8");){
            ((VelocityEngine)this.velocityEngineProvider.get()).evaluate((Context)vctx, (Writer)sw, item.getRepositoryItemUid().toString(), (Reader)isr);
            StringContentLocator stringContentLocator = new StringContentLocator(sw.toString());
            return stringContentLocator;
        }
        catch (Exception e) {
            throw new LocalStorageException("Could not expand the template: " + item.getRepositoryItemUid().toString(), e);
        }
    }
}

