/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import org.sonatype.nexus.proxy.item.LockResource;
import org.sonatype.sisu.locks.ResourceLock;

final class SisuLockResource
implements LockResource {
    private final ResourceLock lock;

    SisuLockResource(ResourceLock lock) {
        this.lock = lock;
    }

    @Override
    public void lockShared() {
        Thread self = Thread.currentThread();
        if (this.lock.getExclusiveCount(self) > 0) {
            this.lock.lockExclusive(self);
        } else {
            this.lock.lockShared(self);
        }
    }

    @Override
    public void lockExclusively() {
        this.lock.lockExclusive(Thread.currentThread());
    }

    @Override
    public void unlock() {
        Thread self = Thread.currentThread();
        if (this.lock.getExclusiveCount(self) > 0) {
            this.lock.unlockExclusive(self);
        } else {
            this.lock.unlockShared(self);
        }
    }

    @Override
    public boolean hasLocksHeld() {
        Thread self = Thread.currentThread();
        for (Thread t : this.lock.getOwners()) {
            if (self != t) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int sharedCount = 0;
        int exclusiveCount = 0;
        for (Thread t : this.lock.getOwners()) {
            sharedCount += this.lock.getSharedCount(t);
            exclusiveCount += this.lock.getExclusiveCount(t);
        }
        return "[Write locks = " + exclusiveCount + ", Read locks = " + sharedCount + "]";
    }
}

