/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sonatype.nexus.proxy.item.LockResource;

final class SimpleLockResource
implements LockResource {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    SimpleLockResource() {
    }

    @Override
    public void lockShared() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
        } else {
            this.lock.readLock().lock();
        }
    }

    @Override
    public void lockExclusively() {
        int i;
        int readHoldCount;
        int n = readHoldCount = this.lock.isWriteLockedByCurrentThread() ? 0 : this.lock.getReadHoldCount();
        if (readHoldCount > 0) {
            for (i = 0; i < readHoldCount; ++i) {
                this.lock.readLock().unlock();
            }
            Thread.yield();
        }
        this.lock.writeLock().lock();
        if (readHoldCount > 0) {
            for (i = 0; i < readHoldCount; ++i) {
                this.lock.readLock().lock();
            }
        }
    }

    @Override
    public void unlock() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean hasLocksHeld() {
        return this.lock.isWriteLockedByCurrentThread() || this.lock.getReadHoldCount() > 0;
    }

    public String toString() {
        return this.lock.toString();
    }
}

