/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.AbstractWrappingContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.util.WrappingInputStream;

public class ReadLockingContentLocator
extends AbstractWrappingContentLocator {
    private final RepositoryItemUid wrappedUid;

    public ReadLockingContentLocator(RepositoryItemUid wrappedUid, ContentLocator wrappedLocator) {
        super(wrappedLocator);
        this.wrappedUid = wrappedUid;
    }

    @Override
    public InputStream getContent() throws IOException {
        RepositoryItemUidLock lock = this.wrappedUid.getLock();
        lock.lock(Action.read);
        try {
            return new ReadLockingInputStream(this.wrappedUid, lock, this.getTarget().getContent());
        }
        catch (IOException e) {
            lock.unlock();
            throw e;
        }
        catch (Exception e) {
            lock.unlock();
            IOException w = new IOException(e.getMessage());
            w.initCause(e);
            throw w;
        }
    }

    private static class ReadLockingInputStream
    extends WrappingInputStream {
        private final RepositoryItemUid uid;
        private volatile RepositoryItemUidLock lock;

        public ReadLockingInputStream(RepositoryItemUid uid, RepositoryItemUidLock lock, InputStream wrappedStream) {
            super(wrappedStream);
            this.uid = uid;
            this.lock = lock;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.lock != null) {
                    this.lock.unlock();
                    this.lock = null;
                }
            }
        }

        public void finalize() throws Throwable {
            try {
                if (this.lock != null) {
                    this.lock.unlock();
                    this.lock = null;
                    LoggerFactory.getLogger(ReadLockingContentLocator.class).warn("UID lock leak detected for UID {}", (Object)this.uid);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

