/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.sonatype.nexus.proxy.item.AbstractContentLocator;
import org.sonatype.nexus.util.WrappingInputStream;
import org.sonatype.nexus.util.file.DirSupport;

public class FileContentLocator
extends AbstractContentLocator {
    private final File file;
    private final boolean deleteOnCloseInput;

    public FileContentLocator(String mimeType) throws IOException {
        this(File.createTempFile("nx-tmp-content-locator", "tmp"), mimeType, true);
    }

    public FileContentLocator(File file, String mimeType) {
        this(file, mimeType, false);
    }

    public FileContentLocator(File file, String mimeType, boolean deleteOnCloseInput) {
        super(mimeType, !deleteOnCloseInput, file.length());
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.deleteOnCloseInput = deleteOnCloseInput;
    }

    public InputStream getInputStream() throws IOException {
        if (this.deleteOnCloseInput) {
            return new DeleteOnCloseFileInputStream(this.getFile());
        }
        return new FileInputStream(this.getFile());
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getFile());
    }

    @Override
    public long getLength() {
        return this.getFile().length();
    }

    public File getFile() {
        return this.file;
    }

    public void delete() throws IOException {
        DirSupport.deleteIfExists(this.getFile().toPath());
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.getInputStream();
    }

    public static class DeleteOnCloseFileInputStream
    extends WrappingInputStream {
        private final File file;

        public DeleteOnCloseFileInputStream(File file) throws IOException {
            super(new FileInputStream(file));
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            DirSupport.deleteIfExists(this.file.toPath());
        }
    }
}

