/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;

public class DefaultStorageFileItem
extends AbstractStorageItem
implements StorageFileItem {
    private transient ContentLocator contentLocator;
    @Deprecated
    private long length;
    @Deprecated
    private String mimeType;

    public DefaultStorageFileItem(Repository repository, ResourceStoreRequest request, boolean canRead, boolean canWrite, ContentLocator contentLocator) {
        super(repository, request, canRead, canWrite);
        this.setContentLocator(contentLocator);
    }

    public DefaultStorageFileItem(RepositoryRouter router, ResourceStoreRequest request, boolean canRead, boolean canWrite, ContentLocator contentLocator) {
        super(router, request, canRead, canWrite);
        this.setContentLocator(contentLocator);
    }

    @Override
    public long getLength() {
        return this.getContentLocator().getLength();
    }

    @Override
    public String getMimeType() {
        return this.getContentLocator().getMimeType();
    }

    @Override
    public boolean isReusableStream() {
        return this.getContentLocator().isReusable();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getContentLocator().getContent();
    }

    @Override
    public long getModified() {
        if (this.isContentGenerated()) {
            return System.currentTimeMillis();
        }
        return super.getModified();
    }

    @Override
    public void setContentLocator(ContentLocator locator) {
        this.contentLocator = (ContentLocator)Preconditions.checkNotNull((Object)locator);
    }

    @Override
    public ContentLocator getContentLocator() {
        return this.contentLocator;
    }

    @Override
    public String getContentGeneratorId() {
        if (this.isContentGenerated()) {
            return this.getRepositoryItemAttributes().get("contentGenerator");
        }
        return null;
    }

    @Override
    public void setContentGeneratorId(String contentGeneratorId) {
        if (Strings.isNullOrEmpty((String)contentGeneratorId)) {
            this.getRepositoryItemAttributes().remove("contentGenerator");
        } else {
            this.getRepositoryItemAttributes().put("contentGenerator", contentGeneratorId);
        }
    }

    @Override
    public boolean isContentGenerated() {
        return this.getRepositoryItemAttributes().containsKey("contentGenerator");
    }

    @Override
    public String toString() {
        if (this.isContentGenerated()) {
            return String.format("%s (file, contentGenerator=%s)", super.toString(), this.getContentGeneratorId());
        }
        return String.format("%s (file)", super.toString());
    }
}

