/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import java.util.Collection;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.router.RepositoryRouter;

public class DefaultStorageCollectionItem
extends AbstractStorageItem
implements StorageCollectionItem {
    public DefaultStorageCollectionItem(Repository repository, ResourceStoreRequest request, boolean canRead, boolean canWrite) {
        super(repository, request, canRead, canWrite);
    }

    public DefaultStorageCollectionItem(RepositoryRouter router, ResourceStoreRequest request, boolean canRead, boolean canWrite) {
        super(router, request, canRead, canWrite);
    }

    @Override
    public Collection<StorageItem> list() throws AccessDeniedException, NoSuchResourceStoreException, IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.isVirtual()) {
            return this.getStore().list(this.getResourceStoreRequest());
        }
        Repository repo = this.getRepositoryItemUid().getRepository();
        Collection<StorageItem> result = repo.list(false, this);
        this.correctPaths(result);
        return result;
    }

    protected void correctPaths(Collection<StorageItem> list) {
        for (StorageItem item : list) {
            if (this.getPath().endsWith("/")) {
                ((AbstractStorageItem)item).setPath(this.getPath() + item.getName());
                continue;
            }
            ((AbstractStorageItem)item).setPath(this.getPath() + "/" + item.getName());
        }
    }

    @Override
    public String toString() {
        return String.format("%s (coll)", super.toString());
    }
}

