/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.item;

import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.LockResource;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;

public class DefaultRepositoryItemUidLock
implements RepositoryItemUidLock {
    private final String key;
    private final LockResource contentLock;

    protected DefaultRepositoryItemUidLock(String key, LockResource contentLock) {
        this.key = key;
        this.contentLock = contentLock;
    }

    @Override
    public void lock(Action action) {
        if (action.isReadAction()) {
            this.contentLock.lockShared();
        } else {
            this.contentLock.lockExclusively();
        }
    }

    @Override
    public void unlock() {
        this.contentLock.unlock();
    }

    @Override
    public boolean hasLocksHeld() {
        return this.contentLock.hasLocksHeld();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRepositoryItemUidLock other = (DefaultRepositoryItemUidLock)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    protected LockResource getContentLock() {
        return this.contentLock;
    }
}

